/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.Constants;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendMessage;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.cluster.JobSchedulerProxy;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class NonPjJobFrontend
implements Runnable,
JobFrontendRef {
    private String username;
    private int jobnum;
    private int Np;
    private TimerThread myLeaseTimerThread;
    private Timer mySchedulerRenewTimer;
    private Timer mySchedulerExpireTimer;
    private Timer myJobTimer;
    private ChannelGroup myMiddlewareChannelGroup;
    private JobSchedulerRef myJobScheduler;
    private boolean continueRun = true;
    private State myState = State.RUNNING;
    private String myCancelMessage = "User canceled job";
    private LinkedList<String> myBackendNames = new LinkedList();

    public NonPjJobFrontend(String username, int Np) throws IOException {
        this.username = username;
        this.Np = Np;
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ NonPjJobFrontend this$0;
            {
                NonPjJobFrontend nonPjJobFrontend = this$0;
                Objects.requireNonNull(nonPjJobFrontend);
                this.this$0 = nonPjJobFrontend;
            }

            @Override
            public void run() {
                this.this$0.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.mySchedulerRenewTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ NonPjJobFrontend this$0;
            {
                NonPjJobFrontend nonPjJobFrontend = this$0;
                Objects.requireNonNull(nonPjJobFrontend);
                this.this$0 = nonPjJobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.schedulerRenewTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.mySchedulerExpireTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ NonPjJobFrontend this$0;
            {
                NonPjJobFrontend nonPjJobFrontend = this$0;
                Objects.requireNonNull(nonPjJobFrontend);
                this.this$0 = nonPjJobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.schedulerExpireTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myJobTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ NonPjJobFrontend this$0;
            {
                NonPjJobFrontend nonPjJobFrontend = this$0;
                Objects.requireNonNull(nonPjJobFrontend);
                this.this$0 = nonPjJobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.jobTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myMiddlewareChannelGroup = new ChannelGroup();
        InetSocketAddress js_address = null;
        Channel js_channel = null;
        try {
            js_address = new InetSocketAddress(PJProperties.getPjHost(), PJProperties.getPjPort());
            js_channel = this.myMiddlewareChannelGroup.connect(js_address);
        }
        catch (IOException exc) {
            throw new JobSchedulerException("JobFrontend(): Cannot contact Job Scheduler Daemon at " + String.valueOf(js_address), exc);
        }
        this.myJobScheduler = new JobSchedulerProxy(this.myMiddlewareChannelGroup, js_channel);
        this.mySchedulerRenewTimer.start(Constants.LEASE_RENEW_INTERVAL, Constants.LEASE_RENEW_INTERVAL);
        this.mySchedulerExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
        this.myJobScheduler.requestJob(this, username, Np, Np, 0);
    }

    public synchronized int getJobNumber() throws InterruptedException {
        while (this.myBackendNames.size() < this.Np) {
            this.wait();
        }
        return this.jobnum;
    }

    public synchronized List<String> getBackendNames() throws InterruptedException {
        while (this.myBackendNames.size() < this.Np) {
            this.wait();
        }
        return Collections.unmodifiableList(this.myBackendNames);
    }

    @Override
    public void run() {
        ObjectItemBuf<JobFrontendMessage> buf = ObjectBuf.buffer((JobFrontendMessage)null);
        Status status = null;
        JobFrontendMessage message = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, buf);
                message = (JobFrontendMessage)buf.item;
                if (status.tag == 4) {
                    message.invoke((JobFrontendRef)this, this.myJobScheduler);
                }
                buf.item = null;
                status = null;
                message = null;
            }
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
        }
        catch (Throwable exc) {
            this.terminateCancelJob(exc);
        }
        switch (this.myState.ordinal()) {
            case 1: {
                System.exit(1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateJobFinished(int status) {
        boolean doExit = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = null;
                doExit = true;
            }
        }
        if (doExit) {
            System.exit(status);
        }
    }

    @Override
    public synchronized void assignBackend(JobSchedulerRef theJobScheduler, String name, String host, String jvm, String classpath, String[] jvmflags, String shellCommand, int Nt) throws IOException {
        int jobtime;
        this.myBackendNames.add(name);
        if (this.myBackendNames.size() == this.Np && (jobtime = PJProperties.getPjJobTime()) > 0) {
            this.myJobTimer.start((long)jobtime * 1000L);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void assignJobNumber(JobSchedulerRef theJobScheduler, int jobnum, String pjhost) throws IOException {
        this.jobnum = jobnum;
        this.notifyAll();
    }

    @Override
    public synchronized void cancelJob(JobSchedulerRef theJobScheduler, String errmsg) throws IOException {
        this.terminateCancelJob(errmsg);
    }

    @Override
    public synchronized void renewLease(JobSchedulerRef theJobScheduler) throws IOException {
        this.mySchedulerExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
    }

    @Override
    public synchronized void backendFinished(JobBackendRef theJobBackend) throws IOException {
    }

    @Override
    public synchronized void backendReady(JobBackendRef theJobBackend, int rank, InetSocketAddress middlewareAddress, InetSocketAddress worldAddress, InetSocketAddress frontendAddress) throws IOException {
    }

    @Override
    public synchronized void cancelJob(JobBackendRef theJobBackend, String errmsg) throws IOException {
    }

    @Override
    public synchronized void renewLease(JobBackendRef theJobBackend) throws IOException {
    }

    @Override
    public synchronized void requestResource(JobBackendRef theJobBackend, String resourceName) throws IOException {
    }

    @Override
    public synchronized void outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) throws IOException {
    }

    @Override
    public synchronized void outputFileWrite(JobBackendRef theJobBackend, int ffd, byte[] buf, int off, int len) throws IOException {
    }

    @Override
    public synchronized void outputFileFlush(JobBackendRef theJobBackend, int ffd) throws IOException {
    }

    @Override
    public synchronized void outputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
    }

    @Override
    public synchronized void inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) throws IOException {
    }

    @Override
    public synchronized void inputFileRead(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
    }

    @Override
    public synchronized void inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) throws IOException {
    }

    @Override
    public synchronized void inputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
    }

    @Override
    public synchronized void reportComment(JobBackendRef theJobBackend, int rank, String comment) throws IOException {
        this.myJobScheduler.reportComment(this, rank, comment);
    }

    @Override
    public void close() {
    }

    private synchronized void schedulerRenewTimeout() throws IOException {
        if (this.mySchedulerRenewTimer.isTriggered()) {
            this.myJobScheduler.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulerExpireTimeout() throws IOException {
        boolean doExit = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            if (this.mySchedulerExpireTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job Scheduler failed";
                    System.err.println(this.myCancelMessage);
                    doExit = true;
                }
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobTimeout() throws IOException {
        boolean doExit = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            if (this.myJobTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job exceeded maximum running time";
                    System.err.println(this.myCancelMessage);
                    doExit = true;
                }
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    private void terminateCancelJob(String msg) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = msg;
            System.err.println(this.myCancelMessage);
        }
    }

    private void terminateCancelJob(Throwable exc) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myCancelMessage = exc.getClass().getName();
            String msg = exc.getMessage();
            if (msg != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + msg;
            }
            System.err.println(this.myCancelMessage);
            exc.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCancelJobOther(Throwable exc) {
        boolean doExit = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = exc.getClass().getName();
                String msg = exc.getMessage();
                if (msg != null) {
                    this.myCancelMessage = this.myCancelMessage + ": " + msg;
                }
                System.err.println(this.myCancelMessage);
                exc.printStackTrace(System.err);
                doExit = true;
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.mySchedulerRenewTimer.stop();
            this.mySchedulerExpireTimer.stop();
            if (this.myState == State.RUNNING && this.myCancelMessage != null) {
                this.myState = State.TERMINATE_CANCEL_JOB;
            }
            switch (this.myState.ordinal()) {
                case 0: {
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.jobFinished(this);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case 1: {
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.cancelJob(this, this.myCancelMessage);
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            this.myState = State.TERMINATING;
        }
    }

    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATING;

    }
}

