/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.BackendInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class Configuration {
    private String myClusterName;
    private String myLogFile;
    private String myWebHost = "0.0.0.0";
    private int myWebPort = 8080;
    private String mySchedulerHost = "localhost";
    private int mySchedulerPort = 20617;
    private String myFrontendHost;
    private ArrayList<BackendInfo> myBackendInfo = new ArrayList();
    private static final String DEFAULT_SHELL_COMMAND = "bash -l -c";
    private int myJobTime;

    public Configuration(String configfile) throws IOException {
        this.parseConfigFile(configfile);
    }

    public String getClusterName() {
        return this.myClusterName;
    }

    public String getLogFile() {
        return this.myLogFile;
    }

    public String getWebHost() {
        return this.myWebHost;
    }

    public int getWebPort() {
        return this.myWebPort;
    }

    public String getSchedulerHost() {
        return this.mySchedulerHost;
    }

    public int getSchedulerPort() {
        return this.mySchedulerPort;
    }

    public String getFrontendHost() {
        return this.myFrontendHost;
    }

    public int getBackendCount() {
        return this.myBackendInfo.size();
    }

    public BackendInfo getBackendInfo(int i) {
        return this.myBackendInfo.get(i);
    }

    public List<BackendInfo> getBackendInfoList() {
        return this.myBackendInfo;
    }

    public int getJobTime() {
        return this.myJobTime;
    }

    private void parseConfigFile(String configfile) throws IOException {
        Scanner scanner = null;
        String line = null;
        long now = System.currentTimeMillis();
        try {
            scanner = new Scanner(new File(configfile));
            while (scanner.hasNextLine()) {
                String command;
                line = scanner.nextLine();
                Scanner linescanner = new Scanner(line);
                if (!linescanner.hasNext() || (command = linescanner.next()).charAt(0) == '#') continue;
                if (command.equals("cluster")) {
                    this.myClusterName = linescanner.nextLine().trim();
                    continue;
                }
                if (command.equals("logfile")) {
                    this.myLogFile = linescanner.next();
                    continue;
                }
                if (command.equals("webhost")) {
                    this.myWebHost = linescanner.next();
                    continue;
                }
                if (command.equals("webport")) {
                    this.myWebPort = Integer.parseInt(linescanner.next());
                    continue;
                }
                if (command.equals("schedulerhost")) {
                    this.mySchedulerHost = linescanner.next();
                    continue;
                }
                if (command.equals("schedulerport")) {
                    this.mySchedulerPort = Integer.parseInt(linescanner.next());
                    continue;
                }
                if (command.equals("frontendhost")) {
                    this.myFrontendHost = linescanner.next();
                    continue;
                }
                if (command.equals("backend")) {
                    String name = linescanner.next();
                    int cpus = linescanner.nextInt();
                    if (cpus < 1) {
                        throw new IOException("Invalid backend command, <cpus> must be >= 1: " + line);
                    }
                    String host = linescanner.next();
                    String jvm = linescanner.next();
                    String classpath = linescanner.next();
                    ArrayList<String> jvmflags = new ArrayList<String>();
                    while (linescanner.hasNext()) {
                        jvmflags.add(linescanner.next());
                    }
                    BackendInfo backendinfo = new BackendInfo(name, cpus, BackendInfo.State.IDLE, now, host, jvm, classpath, jvmflags.toArray(new String[0]), DEFAULT_SHELL_COMMAND);
                    this.myBackendInfo.add(backendinfo);
                    continue;
                }
                if (command.equals("backendshell")) {
                    String name = linescanner.next();
                    String shellCommand = linescanner.nextLine().trim();
                    BackendInfo backendinfo = this.backendInfoForName(name);
                    if (backendinfo == null) {
                        throw new IOException("Invalid backendshell command, no backend named \"" + name + "\"");
                    }
                    backendinfo.shellCommand = shellCommand;
                    continue;
                }
                if (command.equals("jobtime")) {
                    int time = linescanner.nextInt();
                    if (time < 1) {
                        throw new IOException("Invalid configuration command: " + line);
                    }
                    this.myJobTime = time;
                    continue;
                }
                throw new IOException("Invalid configuration command: " + line);
            }
            if (this.myClusterName == null) {
                throw new IOException("Missing configuration command: cluster <name>");
            }
            if (this.myLogFile == null) {
                throw new IOException("Missing configuration command: logfile <file>");
            }
            if (this.myWebHost == null) {
                throw new IOException("Missing configuration command: webhost <host>");
            }
            if (this.myFrontendHost == null) {
                throw new IOException("Missing configuration command: frontendhost <host>");
            }
            if (this.myBackendInfo.isEmpty()) {
                throw new IOException("Missing configuration command: backend <name> <host> <port>");
            }
        }
        catch (NoSuchElementException exc) {
            throw new IOException("Invalid configuration command: " + line);
        }
        catch (NumberFormatException exc) {
            throw new IOException("Invalid configuration command: " + line);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private BackendInfo backendInfoForName(String name) {
        for (BackendInfo backendinfo : this.myBackendInfo) {
            if (!backendinfo.name.equals(name)) continue;
            return backendinfo;
        }
        return null;
    }
}

