/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import java.util.ArrayList;

public class CommPattern {
    private CommPattern() {
    }

    public static int[] broadcastPattern(int size, int rank, int root) {
        if (size < 1) {
            throw new IllegalArgumentException("broadcastPattern(): size must be >= 1");
        }
        if (0 > rank || rank >= size) {
            throw new IllegalArgumentException("broadcastPattern(): rank must be in the range 0 .. " + (size - 1));
        }
        if (0 > root || root >= size) {
            throw new IllegalArgumentException("broadcastPattern(): root must be in the range 0 .. " + (size - 1));
        }
        int thisrank = rank >= root ? rank - root + 1 : rank + size - root + 1;
        int parent = -1;
        ArrayList<Integer> childlist = new ArrayList<Integer>();
        for (int round = 1; round < size; round <<= 1) {
            for (int src = 1; src <= round; ++src) {
                int dst = src + round;
                if (thisrank == dst) {
                    parent = src;
                    continue;
                }
                if (thisrank != src || dst > size) continue;
                childlist.add(dst);
            }
        }
        int n = childlist.size();
        int[] result = new int[n + 1];
        result[0] = parent == -1 ? -1 : (parent + root - 1) % size;
        for (int i = 0; i < n; ++i) {
            result[i + 1] = ((Integer)childlist.get(i) + root - 1) % size;
        }
        return result;
    }
}

