/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.ResourceCache;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BackendClassLoader
extends ClassLoader {
    private JobBackendRef myJobBackend;
    private JobFrontendRef myJobFrontend;
    private ResourceCache myCache;
    private Map<String, URL> myResourceURLMap = Collections.synchronizedMap(new HashMap());

    public BackendClassLoader(JobBackendRef theJobBackend, JobFrontendRef theJobFrontend, ResourceCache theCache) {
        this.myJobBackend = theJobBackend;
        this.myJobFrontend = theJobFrontend;
        this.myCache = theCache;
    }

    public BackendClassLoader(ClassLoader parent, JobBackendRef theJobBackend, JobFrontendRef theJobFrontend, ResourceCache theCache) {
        super(parent);
        this.myJobBackend = theJobBackend;
        this.myJobFrontend = theJobFrontend;
        this.myCache = theCache;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            byte[] content;
            String resourceName = className.replace('.', '/') + ".class";
            if (!this.myCache.contains(resourceName)) {
                this.myJobFrontend.requestResource(this.myJobBackend, resourceName);
            }
            if ((content = this.myCache.get(resourceName)) == null) {
                throw new ClassNotFoundException("Class " + className + " not found");
            }
            return this.defineClass(className, content, 0, content.length);
        }
        catch (IOException exc) {
            throw new ClassNotFoundException("Class " + className + " not found due to I/O error", exc);
        }
        catch (InterruptedException exc) {
            throw new ClassNotFoundException("Class " + className + " not found because thread interrupted", exc);
        }
    }

    @Override
    protected URL findResource(String name) {
        try {
            URL url = this.myResourceURLMap.get(name);
            if (url == null) {
                byte[] content;
                if (!this.myCache.contains(name)) {
                    this.myJobFrontend.requestResource(this.myJobBackend, name);
                }
                if ((content = this.myCache.get(name)) == null) {
                    return null;
                }
                String fname = new File(name).getName();
                int i = fname.lastIndexOf(46);
                String fprefix = i == -1 ? fname : fname.substring(0, i);
                String fsuffix = i == -1 ? null : fname.substring(i);
                File file = File.createTempFile(fprefix + "_tmp", fsuffix);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                ((OutputStream)out).write(content);
                ((OutputStream)out).close();
                file.deleteOnExit();
                url = file.toURI().toURL();
                this.myResourceURLMap.put(name, url);
            }
            return url;
        }
        catch (IOException exc) {
            return null;
        }
        catch (InterruptedException exc) {
            return null;
        }
    }
}

