/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ArrayItemGenerator;
import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.IntegerStrideForLoop;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ItemHolder;
import edu.rit.pj.IteratorItemGenerator;
import edu.rit.pj.Lock;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.LongStrideForLoop;
import edu.rit.pj.ParallelConstruct;
import edu.rit.pj.ParallelIteration;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.ParallelTeamThread;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.util.Iterator;
import java.util.Objects;

public abstract class ParallelRegion
extends ParallelConstruct {
    private Lock myLock = new Lock();

    public void start() throws Exception {
    }

    public abstract void run() throws Exception;

    public void finish() throws Exception {
    }

    public final void execute(int first, int last, IntegerForLoop theLoop) throws Exception {
        this.execute(first, last, theLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int first, int last, IntegerForLoop theLoop, BarrierAction action) throws Exception {
        if (theLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            int currentIndex = currentThread.myIndex;
            IntegerSchedule schedule = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    schedule = theLoop.schedule();
                    schedule.commonStart(this.myTeam.K, new Range(first, last));
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setIntegerSchedule(schedule);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            theLoop.mySchedule = schedule = currentThread.getIntegerSchedule();
            Throwable runException = null;
            try {
                Range chunk;
                theLoop.start();
                while ((chunk = schedule.commonNext(currentIndex)) != null) {
                    theLoop.commonRun(chunk.lb(), chunk.ub());
                }
                theLoop.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                schedule.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theLoop.myTeam = null;
            theLoop.mySchedule = null;
        }
    }

    public final void execute(int first, int last, int stride, IntegerStrideForLoop theLoop) throws Exception {
        this.execute(first, last, stride, theLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int first, int last, int stride, IntegerStrideForLoop theLoop, BarrierAction action) throws Exception {
        if (stride <= 0) {
            throw new IllegalArgumentException("ParallelRegion.execute(): Stride = " + stride + " illegal");
        }
        if (theLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            int currentIndex = currentThread.myIndex;
            IntegerSchedule schedule = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    schedule = theLoop.schedule();
                    schedule.commonStart(this.myTeam.K, new Range(first, last, stride));
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setIntegerSchedule(schedule);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            theLoop.mySchedule = schedule = currentThread.getIntegerSchedule();
            Throwable runException = null;
            try {
                Range chunk;
                theLoop.start();
                while ((chunk = schedule.commonNext(currentIndex)) != null) {
                    theLoop.commonRun(chunk.lb(), chunk.ub(), chunk.stride());
                }
                theLoop.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                schedule.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theLoop.myTeam = null;
            theLoop.mySchedule = null;
        }
    }

    public final void execute(long first, long last, LongForLoop theLoop) throws Exception {
        this.execute(first, last, theLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long first, long last, LongForLoop theLoop, BarrierAction action) throws Exception {
        if (theLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            int currentIndex = currentThread.myIndex;
            LongSchedule schedule = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    schedule = theLoop.schedule();
                    schedule.commonStart(this.myTeam.K, new LongRange(first, last));
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setLongSchedule(schedule);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            theLoop.mySchedule = schedule = currentThread.getLongSchedule();
            Throwable runException = null;
            try {
                LongRange chunk;
                theLoop.start();
                while ((chunk = schedule.commonNext(currentIndex)) != null) {
                    theLoop.commonRun(chunk.lb(), chunk.ub());
                }
                theLoop.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                schedule.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theLoop.myTeam = null;
            theLoop.mySchedule = null;
        }
    }

    public final void execute(long first, long last, long stride, LongStrideForLoop theLoop) throws Exception {
        this.execute(first, last, stride, theLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long first, long last, long stride, LongStrideForLoop theLoop, BarrierAction action) throws Exception {
        if (stride <= 0L) {
            throw new IllegalArgumentException("ParallelRegion.execute(): Stride = " + stride + " illegal");
        }
        if (theLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theLoop.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            int currentIndex = currentThread.myIndex;
            LongSchedule schedule = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    schedule = theLoop.schedule();
                    schedule.commonStart(this.myTeam.K, new LongRange(first, last, stride));
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setLongSchedule(schedule);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            theLoop.mySchedule = schedule = currentThread.getLongSchedule();
            Throwable runException = null;
            try {
                LongRange chunk;
                theLoop.start();
                while ((chunk = schedule.commonNext(currentIndex)) != null) {
                    theLoop.commonRun(chunk.lb(), chunk.ub(), chunk.stride());
                }
                theLoop.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                schedule.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theLoop.myTeam = null;
            theLoop.mySchedule = null;
        }
    }

    public final <T> void execute(T[] theArray, ParallelIteration<T> theIteration) throws Exception {
        this.execute(theArray, theIteration, BarrierAction.WAIT);
    }

    private static <T> ItemGenerator<T> castItemGenerator(Object obj) {
        return (ItemGenerator)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(T[] theArray, ParallelIteration<T> theIteration, BarrierAction action) throws Exception {
        if (theArray == null) {
            throw new NullPointerException("ParallelRegion.execute(): Array is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theIteration.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            ItemGenerator<T> generator = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    generator = new ArrayItemGenerator<T>(theArray);
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setItemGenerator(generator);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            generator = ParallelRegion.castItemGenerator(currentThread.getItemGenerator());
            theIteration.myItemGenerator = generator;
            Throwable runException = null;
            try {
                ItemHolder<T> itemholder;
                theIteration.start();
                while ((itemholder = generator.nextItem()) != null) {
                    theIteration.commonRun(itemholder.mySequenceNumber, itemholder.myItem);
                }
                theIteration.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                generator.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theIteration.myTeam = null;
            theIteration.myItemGenerator = null;
        }
    }

    public final <T> void execute(Iterator<T> theIterator, ParallelIteration<T> theIteration) throws Exception {
        this.execute(theIterator, theIteration, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterator<T> theIterator, ParallelIteration<T> theIteration, BarrierAction action) throws Exception {
        if (theIterator == null) {
            throw new NullPointerException("ParallelRegion.execute(): Iterator is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theIteration.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            ItemGenerator<T> generator = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    generator = new IteratorItemGenerator<T>(theIterator);
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setItemGenerator(generator);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            generator = ParallelRegion.castItemGenerator(currentThread.getItemGenerator());
            theIteration.myItemGenerator = generator;
            Throwable runException = null;
            try {
                ItemHolder<T> itemholder;
                theIteration.start();
                while ((itemholder = generator.nextItem()) != null) {
                    theIteration.commonRun(itemholder.mySequenceNumber, itemholder.myItem);
                }
                theIteration.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                generator.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theIteration.myTeam = null;
            theIteration.myItemGenerator = null;
        }
    }

    public final <T> void execute(Iterable<T> theIterable, ParallelIteration<T> theIteration) throws Exception {
        this.execute(theIterable, theIteration, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterable<T> theIterable, ParallelIteration<T> theIteration, BarrierAction action) throws Exception {
        if (theIterable == null) {
            throw new NullPointerException("ParallelRegion.execute(): Iterable collection is null");
        }
        if (theIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            theIteration.myTeam = this.myTeam;
            ParallelTeamThread currentThread = this.getCurrentThread();
            ItemGenerator<T> generator = null;
            if (currentThread.arriveAtParallelConstruct()) {
                try {
                    generator = new IteratorItemGenerator<T>(theIterable.iterator());
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setItemGenerator(generator);
                    }
                }
                catch (Throwable exc) {
                    for (ParallelTeamThread thread : this.myTeam.myThread) {
                        thread.setConstructException(exc);
                    }
                }
            }
            generator = ParallelRegion.castItemGenerator(currentThread.getItemGenerator());
            theIteration.myItemGenerator = generator;
            Throwable runException = null;
            try {
                ItemHolder<T> itemholder;
                theIteration.start();
                while ((itemholder = generator.nextItem()) != null) {
                    theIteration.commonRun(itemholder.mySequenceNumber, itemholder.myItem);
                }
                theIteration.finish();
            }
            catch (Throwable exc) {
                runException = exc;
                generator.myBreak = true;
            }
            action.doBarrier(currentThread);
            ParallelTeam.rethrow(runException);
        }
        finally {
            theIteration.myTeam = null;
            theIteration.myItemGenerator = null;
        }
    }

    public final void execute(ParallelSection section) throws Exception {
        this.execute(new ParallelSection[]{section}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection section, BarrierAction action) throws Exception {
        this.execute(new ParallelSection[]{section}, action);
    }

    public final void execute(ParallelSection section1, ParallelSection section2) throws Exception {
        this.execute(new ParallelSection[]{section1, section2}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection section1, ParallelSection section2, BarrierAction action) throws Exception {
        this.execute(new ParallelSection[]{section1, section2}, action);
    }

    public final void execute(ParallelSection section1, ParallelSection section2, ParallelSection section3) throws Exception {
        this.execute(new ParallelSection[]{section1, section2, section3}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection section1, ParallelSection section2, ParallelSection section3, BarrierAction action) throws Exception {
        this.execute(new ParallelSection[]{section1, section2, section3}, action);
    }

    public final void execute(ParallelSection[] sections) throws Exception {
        this.execute(sections, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection[] sections, BarrierAction action) throws Exception {
        if (sections == null) {
            throw new NullPointerException("ParallelRegion.execute(): sections is null");
        }
        for (ParallelSection section : sections) {
            if (section != null) continue;
            throw new NullPointerException("ParallelRegion.execute(): A parallel section is null");
        }
        if (action == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        this.execute(sections, new ParallelIteration<ParallelSection>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run(ParallelSection section) throws Exception {
                try {
                    section.myTeam = this.myTeam;
                    section.run();
                }
                finally {
                    section.myTeam = null;
                }
            }
        }, action);
    }

    public final void critical(ParallelSection theSection) throws Exception {
        this.critical(this.myLock, theSection);
    }

    public final void criticalNonexclusive(ParallelSection theSection) throws Exception {
        this.criticalNonexclusive(this.myLock, theSection);
    }

    public final void critical(Lock theLock, ParallelSection theSection) throws Exception {
        if (theLock == null) {
            throw new NullPointerException("ParallelRegion.critical(): Lock is null");
        }
        if (theSection == null) {
            throw new NullPointerException("ParallelRegion.critical(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.critical(): No parallel team executing");
        }
        theLock.lockExclusive();
        try {
            theSection.myTeam = this.myTeam;
            theSection.run();
        }
        finally {
            theSection.myTeam = null;
            theLock.unlockExclusive();
        }
    }

    public final void criticalNonexclusive(Lock theLock, ParallelSection theSection) throws Exception {
        if (theLock == null) {
            throw new NullPointerException("ParallelRegion.criticalNonexclusive(): Lock is null");
        }
        if (theSection == null) {
            throw new NullPointerException("ParallelRegion.criticalNonexclusive(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.criticalNonexclusive(): No parallel team executing");
        }
        theLock.lockNonexclusive();
        try {
            theSection.myTeam = this.myTeam;
            theSection.run();
        }
        finally {
            theSection.myTeam = null;
            theLock.unlockNonexclusive();
        }
    }

    public final void barrier() {
        this.getCurrentThread().barrier();
    }

    public final void barrier(BarrierAction action) throws Exception {
        if (action == null) {
            throw new NullPointerException("ParallelRegion.barrier(): Barrier action is null");
        }
        action.doBarrier(this.getCurrentThread());
    }
}

