/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

public class PJProperties {
    private PJProperties() {
    }

    public static int getPjNn() {
        int k = 1;
        String pj_nn = System.getProperty("pj.nn");
        if (pj_nn != null) {
            try {
                k = Integer.parseInt(pj_nn);
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("pj.nn system property is not an integer >= 1");
            }
            if (k < 1) {
                throw new IllegalArgumentException("pj.nn system property is not an integer >= 1");
            }
        } else {
            String pj_np = System.getProperty("pj.np");
            if (pj_np != null) {
                try {
                    k = Integer.parseInt(pj_np);
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
                }
                if (k < 1) {
                    throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
                }
            }
        }
        return k;
    }

    public static int getPjNp() {
        int k = 1;
        String pj_np = System.getProperty("pj.np");
        if (pj_np != null) {
            try {
                k = Integer.parseInt(pj_np);
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
            }
            if (k < 1) {
                throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
            }
        } else {
            String pj_nn = System.getProperty("pj.nn");
            if (pj_nn != null) {
                try {
                    k = Integer.parseInt(pj_nn);
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("pj.nn system property is not an integer >= 1");
                }
                if (k < 1) {
                    throw new IllegalArgumentException("pj.nn system property is not an integer >= 1");
                }
            }
        }
        return k;
    }

    public static int getPjNt() {
        int k = 0;
        String pj_nt = System.getProperty("pj.nt");
        if (pj_nt != null) {
            try {
                k = Integer.parseInt(pj_nt);
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("pj.nt system property is not an integer >= 1");
            }
            if (k < 1) {
                throw new IllegalArgumentException("pj.nt system property is not an integer >= 1");
            }
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", pj_nt);
        }
        return k;
    }

    public static boolean getPjVt() {
        String pjVtProperty = System.getProperty("pj.vt");
        if (pjVtProperty != null) {
            return Boolean.parseBoolean(pjVtProperty);
        }
        return false;
    }

    public static String getPjSchedule() {
        return System.getProperty("pj.schedule");
    }

    public static String getPjHost() {
        return System.getProperty("pj.host", "localhost");
    }

    public static int getPjPort() {
        try {
            String pj_port = System.getProperty("pj.port");
            int port = pj_port == null ? 20617 : Integer.parseInt(pj_port);
            return port;
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("pj.port system property is not an integer");
        }
    }

    public static int getPjJobTime() {
        try {
            String pj_jobtime = System.getProperty("pj.jobtime");
            if (pj_jobtime == null) {
                return 0;
            }
            int jobtime = Integer.parseInt(pj_jobtime);
            if (jobtime < 1) {
                throw new IllegalArgumentException("pj.jobtime system property is not an integer >= 1");
            }
            return jobtime;
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("pj.jobtime system property is not an integer >= 1");
        }
    }

    public static String getPjJvmFlags() {
        return System.getProperty("pj.jvmflags", "");
    }

    public static String getPjPrng() {
        return System.getProperty("pj.prng", "edu.rit.util.DefaultRandom");
    }
}

