/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.DynamicLongSchedule;
import edu.rit.pj.FixedLongSchedule;
import edu.rit.pj.GuidedLongSchedule;
import edu.rit.pj.PJProperties;
import edu.rit.pj.Schedule;
import edu.rit.util.LongRange;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class LongSchedule
extends Schedule {
    AtomicLong myOrderedIndex = new AtomicLong();

    protected LongSchedule() {
    }

    public static LongSchedule fixed() {
        return new FixedLongSchedule();
    }

    public static LongSchedule dynamic() {
        return new DynamicLongSchedule(1L);
    }

    public static LongSchedule dynamic(long theChunkSize) {
        return new DynamicLongSchedule(theChunkSize);
    }

    public static LongSchedule guided() {
        return new GuidedLongSchedule(1L);
    }

    public static LongSchedule guided(long theChunkSize) {
        return new GuidedLongSchedule(theChunkSize);
    }

    public static LongSchedule runtime() {
        return LongSchedule.runtime(LongSchedule.fixed());
    }

    public static LongSchedule runtime(LongSchedule defaultSchedule) {
        String s = PJProperties.getPjSchedule();
        return s == null ? defaultSchedule : LongSchedule.parse(s);
    }

    public static LongSchedule parse(String s) {
        try {
            int p1 = s.indexOf(40);
            if (p1 == -1) {
                Class<?> subclass = Class.forName(LongSchedule.getSubclassName(s), true, Thread.currentThread().getContextClassLoader());
                return (LongSchedule)subclass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            int p2 = s.indexOf(41);
            if (p2 != s.length() - 1) {
                throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal");
            }
            String[] args = s.substring(p1 + 1, p2).split(",");
            Class<?> subclass = Class.forName(LongSchedule.getSubclassName(s.substring(0, p1)), true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = subclass.getConstructor(String[].class);
            return (LongSchedule)constructor.newInstance(new Object[]{args});
        }
        catch (ClassCastException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (InstantiationException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (InvocationTargetException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + s + "\" illegal", exc);
        }
    }

    public abstract boolean isFixedSchedule();

    private static String getSubclassName(String name) {
        if (name.equals("fixed")) {
            return "edu.rit.pj.FixedLongSchedule";
        }
        if (name.equals("dynamic")) {
            return "edu.rit.pj.DynamicLongSchedule";
        }
        if (name.equals("guided")) {
            return "edu.rit.pj.GuidedLongSchedule";
        }
        return name;
    }

    void commonStart(int K, LongRange theLoopRange) {
        this.myBreak = false;
        this.myOrderedIndex.set(theLoopRange.lb());
        this.start(K, theLoopRange);
    }

    public abstract void start(int var1, LongRange var2);

    LongRange commonNext(int theThreadIndex) {
        if (this.myBreak) {
            return null;
        }
        return this.next(theThreadIndex);
    }

    public abstract LongRange next(int var1);
}

