/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.PJProperties;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

public class HybridTeam
extends WorkerTeam {
    int[] lowestIndex;

    public HybridTeam() throws IOException {
        this(HybridTeam.getDefaultThreadCount(), Comm.world());
    }

    public HybridTeam(int K) throws IOException {
        this(K, Comm.world());
    }

    public HybridTeam(Comm comm) throws IOException {
        this(HybridTeam.getDefaultThreadCount(), comm);
    }

    public HybridTeam(int K, Comm comm) throws IOException {
        super(false);
        if (K <= 0) {
            throw new IllegalArgumentException("HybridTeam(): K = " + K + " illegal");
        }
        if (comm == null) {
            throw new NullPointerException("HybridTeam(): comm is null");
        }
        int size = comm.size();
        int rank = comm.rank();
        this.lowestIndex = new int[size + 1];
        this.lowestIndex[rank] = K;
        Buf[] bufs = IntegerBuf.sliceBuffers(this.lowestIndex, new Range(0, size - 1).subranges(size));
        IntegerBuf myBuf = bufs[rank];
        comm.allGather(Integer.MIN_VALUE, myBuf, bufs);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            int tmp = this.lowestIndex[i];
            this.lowestIndex[i] = count;
            count += tmp;
        }
        this.lowestIndex[size] = count;
        this.initialize(K, comm, size, rank, count, this.lowestIndex[rank]);
    }

    public static int getDefaultThreadCount() {
        int k = PJProperties.getPjNt();
        if (k == 0) {
            k = Runtime.getRuntime().availableProcessors();
        }
        return k;
    }

    @Override
    public int workerRank(int w) {
        if (0 > w || w >= this.count) {
            throw new IllegalArgumentException("HybridTeam.workerRank(): w (= " + w + ") illegal");
        }
        int L = 0;
        int U = this.size;
        while (U - L > 1) {
            int M = (L + U) / 2;
            if (w >= this.lowestIndex[M]) {
                L = M;
                continue;
            }
            U = M;
        }
        return L;
    }
}

