/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.LongSchedule;
import edu.rit.util.LongRange;
import java.util.concurrent.atomic.AtomicLong;

class GuidedLongSchedule
extends LongSchedule {
    private int two_K;
    private LongRange myLoopRange;
    private long myLoopRangeLength;
    private AtomicLong N1 = new AtomicLong();
    private long N2;

    public GuidedLongSchedule() {
        this(1L);
    }

    public GuidedLongSchedule(long theChunkSize) {
        if (theChunkSize < 1L) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Minimum chunk size = " + theChunkSize + " illegal");
        }
        this.N2 = theChunkSize;
    }

    public GuidedLongSchedule(String[] args) {
        this(GuidedLongSchedule.getChunkSize(args));
    }

    private static long getChunkSize(String[] args) {
        long theChunkSize;
        if (args.length != 1) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Usage: -Dpj.schedule=guided or -Dpj.schedule=\"guided(<n>)\"");
        }
        try {
            theChunkSize = Long.parseLong(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("GuidedLongSchedule(): Chunk size = " + args[0] + " illegal");
        }
        return theChunkSize;
    }

    @Override
    public boolean isFixedSchedule() {
        return false;
    }

    @Override
    public void start(int K, LongRange theLoopRange) {
        this.two_K = 2 * K;
        this.myLoopRange = theLoopRange;
        this.myLoopRangeLength = theLoopRange.length();
        this.N1.set(0L);
    }

    @Override
    public LongRange next(int theThreadIndex) {
        LongRange result;
        long N;
        long newN1;
        long oldN1;
        do {
            if ((N = (result = this.myLoopRange.chunk(oldN1 = this.N1.get(), Math.max(this.N2, (this.myLoopRangeLength - oldN1) / (long)this.two_K))).length()) != 0L) continue;
            return null;
        } while (!this.N1.compareAndSet(oldN1, newN1 = oldN1 + N));
        return result;
    }
}

