/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.concurrent.atomic.AtomicInteger;

class DynamicIntegerSchedule
extends IntegerSchedule {
    private Range myLoopRange;
    private AtomicInteger N1 = new AtomicInteger();
    private int N2;

    public DynamicIntegerSchedule() {
        this(1);
    }

    public DynamicIntegerSchedule(int theChunkSize) {
        if (theChunkSize < 1) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Chunk size = " + theChunkSize + " illegal");
        }
        this.N2 = theChunkSize;
    }

    public DynamicIntegerSchedule(String[] args) {
        this(DynamicIntegerSchedule.getChunkSize(args));
    }

    private static int getChunkSize(String[] args) {
        int theChunkSize;
        if (args.length != 1) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Usage: -Dpj.schedule=dynamic or -Dpj.schedule=\"dynamic(<n>)\"");
        }
        try {
            theChunkSize = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Chunk size = " + args[0] + " illegal");
        }
        return theChunkSize;
    }

    @Override
    public boolean isFixedSchedule() {
        return false;
    }

    @Override
    public void start(int K, Range theLoopRange) {
        this.myLoopRange = theLoopRange;
        this.N1.set(0);
    }

    @Override
    public Range next(int theThreadIndex) {
        Range result;
        int N;
        int newN1;
        int oldN1;
        do {
            if ((N = (result = this.myLoopRange.chunk(oldN1 = this.N1.get(), this.N2)).length()) != 0) continue;
            return null;
        } while (!this.N1.compareAndSet(oldN1, newN1 = oldN1 + N));
        return result;
    }
}

