/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.IORequest;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.pj.CommRequest;
import edu.rit.pj.CommStatus;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.CommPattern;
import edu.rit.pj.cluster.JobBackend;
import edu.rit.pj.cluster.JobFrontend;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Objects;

public class Comm {
    private static Comm theWorldCommunicator;
    private static Comm theFrontendCommunicator;
    private int mySize;
    private int myRank;
    private String myHost;
    private int mySizePowerOf2;
    private ChannelGroup myChannelGroup;
    private InetSocketAddress[] myAddressForRank;
    private Channel[] myChannelForRank;
    private int[][] myBroadcastTree;

    private Comm(int size, int rank, String host, ChannelGroup channelgroup, InetSocketAddress[] address) {
        int p2;
        this.mySize = size;
        this.myRank = rank;
        this.myHost = host;
        this.myChannelGroup = channelgroup;
        for (p2 = 1; p2 <= size; p2 <<= 1) {
        }
        this.mySizePowerOf2 = p2 >>> 1;
        this.myChannelGroup.setChannelGroupId(rank);
        this.myChannelGroup.setConnectListener(new ConnectListener(this){
            final /* synthetic */ Comm this$0;
            {
                Comm comm = this$0;
                Objects.requireNonNull(comm);
                this.this$0 = comm;
            }

            @Override
            public void nearEndConnected(ChannelGroup theChannelGroup, Channel theChannel) throws IOException {
            }

            @Override
            public void farEndConnected(ChannelGroup theChannelGroup, Channel theChannel) throws IOException {
                this.this$0.doFarEndConnected(theChannel);
            }
        });
        this.myAddressForRank = address;
        this.myChannelForRank = new Channel[size];
        this.myChannelForRank[this.myRank] = channelgroup.loopbackChannel();
        if (this.mySize > 1) {
            this.myChannelGroup.startListening();
        }
    }

    public static void init(String[] args) throws IOException {
        if (args == null) {
            throw new NullPointerException("Comm.init(): args is null");
        }
        JobBackend backend = JobBackend.getJobBackend();
        if (backend == null) {
            String username = System.getProperty("user.name");
            int Nn = PJProperties.getPjNn();
            int Np = PJProperties.getPjNp();
            int Nt = PJProperties.getPjNt();
            boolean hasFrontendComm = false;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement bottom = stack[stack.length - 1];
            if (!bottom.getMethodName().equals("main")) {
                theWorldCommunicator = new Comm(1, 0, "<unknown>", new ChannelGroup(), new InetSocketAddress[]{new InetSocketAddress(0)});
                return;
            }
            String mainClassName = bottom.getClassName();
            JobFrontend frontend = null;
            try {
                frontend = new JobFrontend(username, Nn, Np, Nt, hasFrontendComm, mainClassName, args);
                frontend.run();
                System.exit(0);
            }
            catch (JobSchedulerException exc) {
                theWorldCommunicator = new Comm(1, 0, "<unknown>", new ChannelGroup(), new InetSocketAddress[]{new InetSocketAddress(0)});
            }
        } else {
            theWorldCommunicator = new Comm(backend.getK(), backend.getRank(), backend.getBackendHost(), backend.getWorldChannelGroup(), backend.getWorldAddress());
        }
    }

    public static Comm world() {
        if (theWorldCommunicator != null) {
            return theWorldCommunicator;
        }
        if (JobBackend.getJobBackend() != null) {
            throw new IllegalStateException("Comm.world(): Didn't call Comm.init()");
        }
        throw new IllegalStateException("Comm.world(): World communicator doesn't exist in job frontend process");
    }

    public int size() {
        return this.mySize;
    }

    public int rank() {
        return this.myRank;
    }

    public String host() {
        return this.myHost;
    }

    public Comm createComm(boolean participate) throws IOException {
        return this.createComm(participate, 0);
    }

    public Comm createComm(boolean participate, int tag) throws IOException {
        InetSocketAddress[] address = new InetSocketAddress[this.mySize];
        Buf[] addressbuf = ObjectBuf.sliceBuffers(address, new Range(0, this.mySize - 1).subranges(this.mySize));
        ChannelGroup channelgroup = null;
        InetSocketAddress myaddress = null;
        if (participate) {
            channelgroup = new ChannelGroup(new InetSocketAddress(this.myChannelGroup.listenAddress().getAddress(), 0));
            address[this.myRank] = myaddress = channelgroup.listenAddress();
        }
        this.allGather(tag, addressbuf[this.myRank], addressbuf);
        int off = 0;
        int newsize = 0;
        int newrank = -1;
        for (int i = 0; i < this.mySize; ++i) {
            if (address[i] == null) {
                ++off;
                continue;
            }
            if (i == this.myRank) {
                newrank = i - off;
            }
            address[i - off] = address[i];
            ++newsize;
        }
        if (newsize == 0) {
            throw new IOException("Comm.createComm(): No processes in communicator");
        }
        if (participate) {
            return new Comm(newsize, newrank, this.myHost, channelgroup, address);
        }
        return null;
    }

    public void send(int toRank, Buf buffer) throws IOException {
        this.send(toRank, 0, buffer);
    }

    public void send(int toRank, int tag, Buf buffer) throws IOException {
        this.myChannelGroup.send(this.getChannel(toRank), tag, buffer);
    }

    public CommRequest send(int toRank, Buf buffer, CommRequest request) throws IOException {
        return this.send(toRank, 0, buffer, request);
    }

    public CommRequest send(int toRank, int tag, Buf buffer, CommRequest request) throws IOException {
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = new IORequest();
        req.myRecvRequest = null;
        this.myChannelGroup.sendNoWait(this.getChannel(toRank), tag, buffer, req.mySendRequest);
        return req;
    }

    public CommStatus receive(Integer fromRank, Buf buffer) throws IOException {
        return this.receive(fromRank, 0, buffer);
    }

    public CommStatus receive(Integer fromRank, int tag, Buf buffer) throws IOException {
        Status status;
        if (fromRank == null) {
            for (int src = 0; src < this.mySize; ++src) {
                this.ensureChannel(src);
            }
            status = this.myChannelGroup.receive(null, tag, buffer);
        } else {
            status = this.myChannelGroup.receive(this.getChannel(fromRank), tag, buffer);
        }
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommStatus receive(Integer fromRank, Range tagRange, Buf buffer) throws IOException {
        Status status;
        if (fromRank == null) {
            for (int src = 0; src < this.mySize; ++src) {
                this.ensureChannel(src);
            }
            status = this.myChannelGroup.receive(null, tagRange, buffer);
        } else {
            status = this.myChannelGroup.receive(this.getChannel(fromRank), tagRange, buffer);
        }
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest receive(Integer fromRank, Buf buffer, CommRequest request) throws IOException {
        return this.receive(fromRank, 0, buffer, request);
    }

    public CommRequest receive(Integer fromRank, int tag, Buf buffer, CommRequest request) throws IOException {
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = null;
        req.myRecvRequest = new IORequest();
        if (fromRank == null) {
            for (int src = 0; src < this.mySize; ++src) {
                this.ensureChannel(src);
            }
            this.myChannelGroup.receiveNoWait(null, tag, buffer, req.myRecvRequest);
        } else {
            this.myChannelGroup.receiveNoWait(this.getChannel(fromRank), tag, buffer, req.myRecvRequest);
        }
        return req;
    }

    public CommRequest receive(Integer fromRank, Range tagRange, Buf buffer, CommRequest request) throws IOException {
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = null;
        req.myRecvRequest = new IORequest();
        if (fromRank == null) {
            for (int src = 0; src < this.mySize; ++src) {
                this.ensureChannel(src);
            }
            this.myChannelGroup.receiveNoWait(null, tagRange, buffer, req.myRecvRequest);
        } else {
            this.myChannelGroup.receiveNoWait(this.getChannel(fromRank), tagRange, buffer, req.myRecvRequest);
        }
        return req;
    }

    public CommStatus sendReceive(int toRank, Buf sendBuf, int fromRank, Buf recvBuf) throws IOException {
        return this.sendReceive(toRank, 0, sendBuf, fromRank, 0, recvBuf);
    }

    public CommStatus sendReceive(int toRank, int sendTag, Buf sendBuf, int fromRank, int recvTag, Buf recvBuf) throws IOException {
        IORequest sendRequest = new IORequest();
        this.myChannelGroup.sendNoWait(this.getChannel(toRank), sendTag, sendBuf, sendRequest);
        IORequest recvRequest = new IORequest();
        this.myChannelGroup.receiveNoWait(this.getChannel(fromRank), recvTag, recvBuf, recvRequest);
        sendRequest.waitForFinish();
        Status status = recvRequest.waitForFinish();
        return new CommStatus(Comm.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest sendReceive(int toRank, Buf sendBuf, int fromRank, Buf recvBuf, CommRequest request) throws IOException {
        return this.sendReceive(toRank, 0, sendBuf, fromRank, 0, recvBuf, request);
    }

    public CommRequest sendReceive(int toRank, int sendTag, Buf sendBuf, int fromRank, int recvTag, Buf recvBuf, CommRequest request) throws IOException {
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = new IORequest();
        this.myChannelGroup.sendNoWait(this.getChannel(toRank), sendTag, sendBuf, req.mySendRequest);
        req.myRecvRequest = new IORequest();
        this.myChannelGroup.receiveNoWait(this.getChannel(fromRank), recvTag, recvBuf, req.myRecvRequest);
        return req;
    }

    public void floodSend(Buf buffer) throws IOException {
        this.floodSend(0, buffer, null).waitForFinish();
    }

    public void floodSend(int tag, Buf buffer) throws IOException {
        this.floodSend(tag, buffer, null).waitForFinish();
    }

    public CommRequest floodSend(Buf buffer, CommRequest request) throws IOException {
        return this.floodSend(0, buffer, request);
    }

    public CommRequest floodSend(int tag, Buf buffer, CommRequest request) throws IOException {
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = new IORequest();
        req.myRecvRequest = null;
        this.myChannelGroup.sendNoWait(this.getChannel(0), tag, buffer, req.mySendRequest);
        return req;
    }

    public CommStatus floodReceive(Buf buffer) throws IOException {
        return this.floodReceive(0, buffer, null).waitForFinish();
    }

    public CommStatus floodReceive(Integer tag, Buf buffer) throws IOException {
        return this.floodReceive(tag, buffer, null).waitForFinish();
    }

    public CommRequest floodReceive(Buf buffer, CommRequest request) throws IOException {
        return this.floodReceive(0, buffer, request);
    }

    public CommRequest floodReceive(Integer tag, Buf buffer, CommRequest request) throws IOException {
        int[] tree = this.getBroadcastTree(0);
        CommRequest req = request == null ? new CommRequest() : request;
        req.mySendRequest = null;
        req.myRecvRequest = new FloodReceiveIORequest(this, tree);
        if (this.myRank == 0) {
            for (int src = 0; src < this.mySize; ++src) {
                this.ensureChannel(src);
            }
            this.myChannelGroup.receiveNoWait(null, tag, buffer, req.myRecvRequest);
        } else {
            for (int i = 1; i < tree.length; ++i) {
                this.ensureChannel(tree[i]);
            }
            this.myChannelGroup.receiveNoWait(this.getChannel(tree[0]), tag, buffer, req.myRecvRequest);
        }
        return req;
    }

    public void broadcast(int root, Buf buffer) throws IOException {
        this.broadcast(root, 0, buffer);
    }

    public void broadcast(int root, int tag, Buf buffer) throws IOException {
        int i;
        if (0 > root || root >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.broadcast(): root = " + root + " out of bounds");
        }
        if (this.mySize == 1) {
            return;
        }
        int[] broadcasttree = this.getBroadcastTree(root);
        int n = broadcasttree.length;
        int parent = broadcasttree[0];
        if (parent != -1) {
            this.myChannelGroup.receive(this.getChannel(parent), tag, buffer);
        }
        IORequest[] iorequest = new IORequest[n];
        for (i = 1; i < n; ++i) {
            int child = broadcasttree[i];
            iorequest[i] = new IORequest();
            this.myChannelGroup.sendNoWait(this.getChannel(child), tag, buffer, iorequest[i]);
        }
        for (i = 1; i < n; ++i) {
            iorequest[i].waitForFinish();
        }
    }

    public void scatter(int root, Buf[] srcarray, Buf dst) throws IOException {
        this.scatter(root, 0, srcarray, dst);
    }

    public void scatter(int root, int tag, Buf[] srcarray, Buf dst) throws IOException {
        if (0 > root || root >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.scatter(): root = " + root + " out of bounds");
        }
        if (this.myRank == root) {
            int rank;
            IORequest[] iorequest = new IORequest[this.mySize];
            for (rank = 0; rank < this.myRank; ++rank) {
                iorequest[rank] = new IORequest();
                this.myChannelGroup.sendNoWait(this.getChannel(rank), tag, srcarray[rank], iorequest[rank]);
            }
            for (rank = this.myRank + 1; rank < this.mySize; ++rank) {
                iorequest[rank] = new IORequest();
                this.myChannelGroup.sendNoWait(this.getChannel(rank), tag, srcarray[rank], iorequest[rank]);
            }
            dst.copy(srcarray[this.myRank]);
            for (rank = 0; rank < this.myRank; ++rank) {
                iorequest[rank].waitForFinish();
            }
            for (rank = this.myRank + 1; rank < this.mySize; ++rank) {
                iorequest[rank].waitForFinish();
            }
        } else {
            this.myChannelGroup.receive(this.getChannel(root), tag, dst);
        }
    }

    public void gather(int root, Buf src, Buf[] dstarray) throws IOException {
        this.gather(root, 0, src, dstarray);
    }

    public void gather(int root, int tag, Buf src, Buf[] dstarray) throws IOException {
        if (0 > root || root >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.gather(): root = " + root + " out of bounds");
        }
        if (this.myRank == root) {
            int rank;
            IORequest[] iorequest = new IORequest[this.mySize];
            for (rank = 0; rank < this.myRank; ++rank) {
                iorequest[rank] = new IORequest();
                this.myChannelGroup.receiveNoWait(this.getChannel(rank), tag, dstarray[rank], iorequest[rank]);
            }
            for (rank = this.myRank + 1; rank < this.mySize; ++rank) {
                iorequest[rank] = new IORequest();
                this.myChannelGroup.receiveNoWait(this.getChannel(rank), tag, dstarray[rank], iorequest[rank]);
            }
            dstarray[this.myRank].copy(src);
            for (rank = 0; rank < this.myRank; ++rank) {
                iorequest[rank].waitForFinish();
            }
            for (rank = this.myRank + 1; rank < this.mySize; ++rank) {
                iorequest[rank].waitForFinish();
            }
        } else {
            this.myChannelGroup.send(this.getChannel(root), tag, src);
        }
    }

    public void allGather(Buf src, Buf[] dstarray) throws IOException {
        this.allGather(0, src, dstarray);
    }

    public void allGather(int tag, Buf src, Buf[] dstarray) throws IOException {
        int pred = (this.myRank - 1 + this.mySize) % this.mySize;
        int succ = (this.myRank + 1) % this.mySize;
        dstarray[this.myRank].copy(src);
        for (int i = 1; i < this.mySize; ++i) {
            this.sendReceive(pred, tag, dstarray[(this.myRank + i - 1) % this.mySize], succ, tag, dstarray[(this.myRank + i) % this.mySize]);
        }
    }

    public void reduce(int root, Buf buffer, Op op) throws IOException {
        this.reduce(root, 0, buffer, op);
    }

    public void reduce(int root, int tag, Buf buffer, Op op) throws IOException {
        if (0 > root || root >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.reduce(): root = " + root + " out of bounds");
        }
        if (this.mySize == 1) {
            return;
        }
        int[] broadcasttree = this.getBroadcastTree(root);
        int n = broadcasttree.length;
        Buf reductionbuf = buffer.getReductionBuf(op);
        for (int i = n - 1; i >= 1; --i) {
            int child = broadcasttree[i];
            this.myChannelGroup.receive(this.getChannel(child), tag, reductionbuf);
        }
        int parent = broadcasttree[0];
        if (parent != -1) {
            this.myChannelGroup.send(this.getChannel(parent), tag, buffer);
        }
    }

    public void allReduce(Buf buffer, Op op) throws IOException {
        this.allReduce(0, buffer, op);
    }

    public void allReduce(int tag, Buf buffer, Op op) throws IOException {
        if (this.mySize == 1) {
            return;
        }
        int outside = this.mySizePowerOf2;
        if (this.myRank >= outside) {
            int insideRank = this.myRank - outside;
            this.send(insideRank, tag, buffer);
            this.receive((Integer)insideRank, tag, buffer);
        } else {
            Buf receiveBuf = buffer.getTemporaryBuf();
            Buf reductionBuf = buffer.getReductionBuf(op);
            int outsideRank = this.myRank + outside;
            if (outsideRank < this.mySize) {
                this.receive((Integer)outsideRank, tag, reductionBuf);
            }
            for (int round = 1; round < outside; round <<= 1) {
                int otherRank = this.myRank ^ round;
                this.sendReceive(otherRank, tag, buffer, otherRank, tag, receiveBuf);
                reductionBuf.copy(receiveBuf);
            }
            if (outsideRank < this.mySize) {
                this.send(outsideRank, tag, buffer);
            }
        }
    }

    public void allToAll(Buf[] srcarray, Buf[] dstarray) throws IOException {
        this.allToAll(0, srcarray, dstarray);
    }

    public void allToAll(int tag, Buf[] srcarray, Buf[] dstarray) throws IOException {
        int i;
        dstarray[this.myRank].copy(srcarray[this.myRank]);
        CommRequest[] commrequest = new CommRequest[this.mySize];
        for (i = 1; i < this.mySize; ++i) {
            int toRank = (this.myRank + i) % this.mySize;
            int fromRank = (this.myRank - i + this.mySize) % this.mySize;
            commrequest[i] = this.sendReceive(toRank, tag, srcarray[toRank], fromRank, tag, dstarray[fromRank], null);
        }
        for (i = 1; i < this.mySize; ++i) {
            commrequest[i].waitForFinish();
        }
    }

    public void scan(Buf buf, Op op) throws IOException {
        this.scan(0, buf, op);
    }

    public void scan(int tag, Buf buf, Op op) throws IOException {
        if (this.mySize == 1) {
            return;
        }
        Buf tempbuf = buf.getTemporaryBuf();
        Buf reductionbuf = buf.getReductionBuf(op);
        int skip = 1;
        while (true) {
            boolean fromExists;
            int toRank = this.myRank + skip;
            int fromRank = this.myRank - skip;
            boolean toExists = 0 <= toRank && toRank < this.mySize;
            boolean bl = fromExists = 0 <= fromRank && fromRank < this.mySize;
            if (toExists && fromExists) {
                this.sendReceive(toRank, tag, buf, fromRank, tag, tempbuf);
                reductionbuf.copy(tempbuf);
            } else if (fromExists) {
                this.receive((Integer)fromRank, tag, reductionbuf);
            } else {
                if (!toExists) break;
                this.send(toRank, tag, buf);
            }
            skip <<= 1;
        }
    }

    public void exclusiveScan(Buf buf, Op op, Object item) throws IOException {
        this.exclusiveScan(0, buf, op, item);
    }

    public void exclusiveScan(int tag, Buf buf, Op op, Object item) throws IOException {
        if (this.myRank == 0) {
            boolean toExists;
            int toRank = 1;
            boolean bl = toExists = toRank < this.mySize;
            if (toExists) {
                this.send(toRank, tag, buf);
            }
            buf.fill(item);
        } else {
            boolean toExists;
            Buf tempbuf = buf.getTemporaryBuf();
            Buf reductionbuf = buf.getReductionBuf(op);
            int toRank = this.myRank + 1;
            int fromRank = this.myRank - 1;
            boolean bl = toExists = 0 <= toRank && toRank < this.mySize;
            if (toExists) {
                this.sendReceive(toRank, tag, buf, fromRank, tag, tempbuf);
                buf.copy(tempbuf);
            } else {
                this.receive((Integer)fromRank, tag, buf);
            }
            int skip = 1;
            while (true) {
                boolean fromExists;
                toRank = this.myRank + skip;
                fromRank = this.myRank - skip;
                toExists = 1 <= toRank && toRank < this.mySize;
                boolean bl2 = fromExists = 1 <= fromRank && fromRank < this.mySize;
                if (toExists && fromExists) {
                    this.sendReceive(toRank, tag, buf, fromRank, tag, tempbuf);
                    reductionbuf.copy(tempbuf);
                } else if (fromExists) {
                    this.receive((Integer)fromRank, tag, reductionbuf);
                } else {
                    if (!toExists) break;
                    this.send(toRank, tag, buf);
                }
                skip <<= 1;
            }
        }
    }

    public void barrier() throws IOException {
        this.barrier(0);
    }

    public void barrier(int tag) throws IOException {
        this.allReduce(tag, IntegerBuf.emptyBuffer(), IntegerOp.SUM);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Comm(size=");
        buf.append(this.mySize);
        buf.append(",rank=");
        buf.append(this.myRank);
        buf.append(",backend");
        for (int i = 0; i < this.mySize; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append('[');
            buf.append(i);
            buf.append("]=");
            buf.append(this.myAddressForRank[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    public void dump(PrintStream out, String prefix) {
        int i;
        out.println();
        out.println(prefix + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        out.println(prefix + "mySize = " + this.mySize);
        out.println(prefix + "myRank = " + this.myRank);
        out.println(prefix + "myHost = " + this.myHost);
        out.println(prefix + "mySizePowerOf2 = " + this.mySizePowerOf2);
        out.println(prefix + "myChannelGroup = " + String.valueOf(this.myChannelGroup));
        out.println(prefix + "myAddressForRank:");
        for (i = 0; i < this.myAddressForRank.length; ++i) {
            out.println(prefix + "\t[" + i + "] " + String.valueOf(this.myAddressForRank[i]));
        }
        out.println(prefix + "myChannelForRank:");
        for (i = 0; i < this.myChannelForRank.length; ++i) {
            out.println(prefix + "\t[" + i + "] " + String.valueOf(this.myChannelForRank[i]));
        }
        out.println(prefix + "myBroadcastTree:");
        for (i = 0; i < this.myBroadcastTree.length; ++i) {
            out.print(prefix + "\t[" + i + "]");
            int[] tree = this.myBroadcastTree[i];
            if (tree == null) {
                out.print(" null");
            } else {
                for (int j = 0; j < tree.length; ++j) {
                    out.print(" " + tree[j]);
                }
            }
            out.println();
        }
        out.println();
        this.myChannelGroup.dump(out, prefix);
    }

    private synchronized void doFarEndConnected(Channel theChannel) throws IOException {
        this.myChannelForRank[Comm.getFarRank((Channel)theChannel)] = theChannel;
        this.notifyAll();
    }

    private synchronized void ensureChannel(int farrank) throws IOException {
        Channel channel = this.myChannelForRank[farrank];
        if (channel == null && this.myRank < farrank) {
            this.myChannelForRank[farrank] = this.myChannelGroup.connect(this.myAddressForRank[farrank]);
        }
    }

    private synchronized Channel getChannel(int farrank) throws IOException {
        Channel channel = this.myChannelForRank[farrank];
        if (channel == null) {
            if (this.myRank < farrank) {
                this.myChannelForRank[farrank] = channel = this.myChannelGroup.connect(this.myAddressForRank[farrank]);
            } else {
                try {
                    while (channel == null) {
                        this.wait();
                        channel = this.myChannelForRank[farrank];
                    }
                }
                catch (InterruptedException exc) {
                    InterruptedIOException exc2 = new InterruptedIOException();
                    exc2.initCause(exc);
                    throw exc2;
                }
            }
        }
        return channel;
    }

    static int getFarRank(Channel channel) {
        return channel.farEndChannelGroupId();
    }

    private synchronized int[] getBroadcastTree(int root) {
        int[] broadcasttree;
        if (this.myBroadcastTree == null) {
            this.myBroadcastTree = new int[this.mySize][];
        }
        if ((broadcasttree = this.myBroadcastTree[root]) == null) {
            broadcasttree = CommPattern.broadcastPattern(this.mySize, this.myRank, root);
            this.myBroadcastTree[root] = broadcasttree;
        }
        return broadcasttree;
    }

    private class FloodReceiveIORequest
    extends IORequest {
        private int[] tree;
        private LinkedList<IORequest> myForwardedIORequests;
        final /* synthetic */ Comm this$0;

        public FloodReceiveIORequest(Comm comm, int[] tree) {
            Comm comm2 = comm;
            Objects.requireNonNull(comm2);
            this.this$0 = comm2;
            this.myForwardedIORequests = new LinkedList();
            this.tree = tree;
        }

        @Override
        public synchronized boolean isFinished() throws IOException {
            if (!super.isFinished()) {
                return false;
            }
            for (IORequest req : this.myForwardedIORequests) {
                if (req.isFinished()) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized Status waitForFinish() throws IOException {
            Status status = super.waitForFinish();
            for (IORequest req : this.myForwardedIORequests) {
                req.waitForFinish();
            }
            return status;
        }

        @Override
        protected synchronized void reportSuccess() {
            try {
                super.reportSuccess();
                int msgtag = this.myStatus.tag;
                int n = this.tree.length;
                for (int i = 1; i < n; ++i) {
                    IORequest req = new IORequest();
                    this.myForwardedIORequests.add(req);
                    this.this$0.myChannelGroup.sendNoWait(this.this$0.getChannel(this.tree[i]), msgtag, this.myBuf, req);
                }
            }
            catch (IOException exc) {
                this.reportFailure(exc);
            }
        }
    }
}

