/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.Unsigned16BitIntegerMatrixBuf;
import edu.rit.mp.buf.Unsigned16BitIntegerMatrixReductionBuf_1;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class Unsigned16BitIntegerMatrixBuf_1
extends Unsigned16BitIntegerMatrixBuf {
    public Unsigned16BitIntegerMatrixBuf_1(int[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public int get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, int item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new Unsigned16BitIntegerMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (IntegerOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        ShortBuffer shortbuffer = buffer.asShortBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, shortbuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            int[] myMatrix_row = this.myMatrix[row];
            while (c < ncols) {
                shortbuffer.put((short)myMatrix_row[col]);
                ++c;
                ++col;
            }
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, shortbuffer.remaining());
        }
        buffer.position(buffer.position() + 2 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        ShortBuffer shortbuffer = buffer.asShortBuffer();
        num = Math.min(num, shortbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            int[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = shortbuffer.get() & 0xFFFF;
                ++col;
            }
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 2 * n);
        return n;
    }
}

