/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.SharedLongReductionBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedLong;
import java.nio.ByteBuffer;

public class SharedLongBuf
extends LongBuf {
    SharedLong myItem;

    public SharedLongBuf(SharedLong item) {
        super(1);
        this.myItem = item;
    }

    @Override
    public long get(int i) {
        return this.myItem.get();
    }

    @Override
    public void put(int i, long item) {
        this.myItem.set(item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedLongReductionBuf(this.myItem, (LongOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            buffer.putLong(this.myItem.get());
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 8) {
            this.myItem.set(buffer.getLong());
            return 1;
        }
        return 0;
    }
}

