/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectMatrixReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;

public class ObjectMatrixBuf<T>
extends ObjectBuf<T> {
    T[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public ObjectMatrixBuf(T[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theRowRange.length() * theColRange.length());
        this.myMatrix = theMatrix;
        this.myRowRange = theRowRange;
        this.myColRange = theColRange;
        this.myLowerRow = theRowRange.lb();
        this.myRowCount = theRowRange.length();
        this.myRowStride = theRowRange.stride();
        this.myLowerCol = theColRange.lb();
        this.myColCount = theColRange.length();
        this.myColStride = theColRange.stride();
    }

    @Override
    public T get(int i) {
        return this.myMatrix[this.i2r(i) * this.myRowStride + this.myLowerRow][this.i2c(i) * this.myColStride + this.myLowerCol];
    }

    @Override
    public void put(int i, T item) {
        this.myMatrix[this.i2r((int)i) * this.myRowStride + this.myLowerRow][this.i2c((int)i) * this.myColStride + this.myLowerCol] = item;
        this.reset();
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ObjectMatrixBuf) {
                ObjectMatrixBuf src = (ObjectMatrixBuf)theSrc;
                Arrays.copy(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
                this.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)theSrc, this);
                this.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ObjectMatrixReductionBuf<T>(this.myMatrix, this.myRowRange, this.myColRange, (ObjectOp)op, this);
    }

    int i2r(int i) {
        return this.myColCount == 0 ? i : i / this.myColCount;
    }

    int i2c(int i) {
        return this.myColCount == 0 ? 0 : i % this.myColCount;
    }
}

