/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectArrayReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;

public class ObjectArrayBuf<T>
extends ObjectBuf<T> {
    T[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public ObjectArrayBuf(T[] theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public T get(int i) {
        return this.myArray[this.myArrayOffset + i * this.myStride];
    }

    @Override
    public void put(int i, T item) {
        this.myArray[this.myArrayOffset + i * this.myStride] = item;
        this.reset();
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ObjectArrayBuf) {
                ObjectArrayBuf src = (ObjectArrayBuf)theSrc;
                Arrays.copy(src.myArray, src.myRange, this.myArray, this.myRange);
                this.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)theSrc, this);
                this.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ObjectArrayReductionBuf<T>(this.myArray, this.myRange, (ObjectOp)op, this);
    }
}

