/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.LongMatrixBuf;
import edu.rit.mp.buf.LongMatrixReductionBuf_1;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

public class LongMatrixBuf_1
extends LongMatrixBuf {
    public LongMatrixBuf_1(long[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public long get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, long item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new LongMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (LongOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        LongBuffer longbuffer = buffer.asLongBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, longbuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            longbuffer.put(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, longbuffer.remaining());
        }
        buffer.position(buffer.position() + 8 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        LongBuffer longbuffer = buffer.asLongBuffer();
        num = Math.min(num, longbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            longbuffer.get(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 8 * n);
        return n;
    }
}

