/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerMatrixBuf;
import edu.rit.mp.buf.IntegerMatrixBuf_1;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class IntegerMatrixReductionBuf_1
extends IntegerMatrixBuf_1 {
    IntegerOp myOp;

    public IntegerMatrixReductionBuf_1(int[][] theMatrix, Range theRowRange, Range theColRange, IntegerOp op) {
        super(theMatrix, theRowRange, theColRange);
        if (op == null) {
            throw new NullPointerException("IntegerMatrixReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, int item) {
        int row = i / this.myColCount + this.myLowerRow;
        int col = i % this.myColCount + this.myLowerCol;
        this.myMatrix[row][col] = this.myOp.op(this.myMatrix[row][col], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof IntegerMatrixBuf) {
                IntegerMatrixBuf src = (IntegerMatrixBuf)theSrc;
                ReduceArrays.reduce(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                IntegerBuf.defaultCopy((IntegerBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        IntBuffer intbuffer = buffer.asIntBuffer();
        num = Math.min(num, intbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            int[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = this.myOp.op(myMatrix_row[col], intbuffer.get());
                ++col;
            }
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 4 * n);
        return n;
    }
}

