/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class FloatItemReductionBuf
extends FloatBuf {
    FloatItemBuf myBuf;
    FloatOp myOp;

    public FloatItemReductionBuf(FloatItemBuf buf, FloatOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("FloatItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public float get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, float item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 4) {
            buffer.putFloat(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 4) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.getFloat());
            return 1;
        }
        return 0;
    }
}

