/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatArrayBuf;
import edu.rit.mp.buf.FloatArrayBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class FloatArrayReductionBuf_1
extends FloatArrayBuf_1 {
    FloatOp myOp;

    public FloatArrayReductionBuf_1(float[] theArray, Range theRange, FloatOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("FloatArrayReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, float item) {
        int off = this.myArrayOffset + i;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof FloatArrayBuf) {
                FloatArrayBuf src = (FloatArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                FloatBuf.defaultCopy((FloatBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getFloat());
            ++index;
            ++off;
        }
        return index - i;
    }
}

