/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatArrayReductionBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class FloatArrayBuf
extends FloatBuf {
    float[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public FloatArrayBuf(float[] theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public float get(int i) {
        return this.myArray[this.myArrayOffset + i * this.myStride];
    }

    @Override
    public void put(int i, float item) {
        this.myArray[this.myArrayOffset + i * this.myStride] = item;
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof FloatArrayBuf) {
                FloatArrayBuf src = (FloatArrayBuf)theSrc;
                Arrays.copy(src.myArray, src.myRange, this.myArray, this.myRange);
            } else {
                FloatBuf.defaultCopy((FloatBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new FloatArrayReductionBuf(this.myArray, this.myRange, (FloatOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 4) {
            buffer.putFloat(this.myArray[off]);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray[off] = buffer.getFloat();
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

