/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterArrayBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class CharacterArrayReductionBuf
extends CharacterArrayBuf {
    CharacterOp myOp;

    public CharacterArrayReductionBuf(char[] theArray, Range theRange, CharacterOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("CharacterArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, char item) {
        int off = this.myArrayOffset + i * this.myStride;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof CharacterArrayBuf) {
                CharacterArrayBuf src = (CharacterArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                CharacterBuf.defaultCopy((CharacterBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 2) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getChar());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

