/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanMatrixBuf;
import edu.rit.mp.buf.BooleanMatrixBuf_1;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class BooleanMatrixReductionBuf_1
extends BooleanMatrixBuf_1 {
    BooleanOp myOp;

    public BooleanMatrixReductionBuf_1(boolean[][] theMatrix, Range theRowRange, Range theColRange, BooleanOp op) {
        super(theMatrix, theRowRange, theColRange);
        if (op == null) {
            throw new NullPointerException("BooleanMatrixReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, boolean item) {
        int row = i / this.myColCount + this.myLowerRow;
        int col = i % this.myColCount + this.myLowerCol;
        this.myMatrix[row][col] = this.myOp.op(this.myMatrix[row][col], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof BooleanMatrixBuf) {
                BooleanMatrixBuf src = (BooleanMatrixBuf)theSrc;
                ReduceArrays.reduce(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                BooleanBuf.defaultCopy((BooleanBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        num = Math.min(num, buffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            boolean[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = this.myOp.op(myMatrix_row[col], buffer.get() != 0);
                ++col;
            }
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        return n;
    }
}

