/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanMatrixReductionBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class BooleanMatrixBuf
extends BooleanBuf {
    boolean[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public BooleanMatrixBuf(boolean[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theRowRange.length() * theColRange.length());
        this.myMatrix = theMatrix;
        this.myRowRange = theRowRange;
        this.myColRange = theColRange;
        this.myLowerRow = theRowRange.lb();
        this.myRowCount = theRowRange.length();
        this.myRowStride = theRowRange.stride();
        this.myLowerCol = theColRange.lb();
        this.myColCount = theColRange.length();
        this.myColStride = theColRange.stride();
    }

    @Override
    public boolean get(int i) {
        return this.myMatrix[this.i2r(i) * this.myRowStride + this.myLowerRow][this.i2c(i) * this.myColStride + this.myLowerCol];
    }

    @Override
    public void put(int i, boolean item) {
        this.myMatrix[this.i2r((int)i) * this.myRowStride + this.myLowerRow][this.i2c((int)i) * this.myColStride + this.myLowerCol] = item;
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof BooleanMatrixBuf) {
                BooleanMatrixBuf src = (BooleanMatrixBuf)theSrc;
                Arrays.copy(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                BooleanBuf.defaultCopy((BooleanBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new BooleanMatrixReductionBuf(this.myMatrix, this.myRowRange, this.myColRange, (BooleanOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int n = 0;
        int r = this.i2r(i);
        int row = r * this.myRowStride + this.myLowerRow;
        int c = this.i2c(i);
        int col = c * this.myColStride + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, buffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            boolean[] myMatrix_row = this.myMatrix[row];
            while (c < ncols) {
                buffer.put(myMatrix_row[col] ? (byte)1 : 0);
                ++c;
                col += this.myColStride;
            }
            n += ncols;
            ++r;
            row += this.myRowStride;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, buffer.remaining());
        }
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        num = Math.min(num, buffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r * this.myRowStride + this.myLowerRow;
        int c = this.i2c(i);
        int col = c * this.myColStride + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            boolean[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = buffer.get() != 0;
                col += this.myColStride;
            }
            n += ncols;
            ++r;
            row += this.myRowStride;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        return n;
    }

    int i2r(int i) {
        return this.myColCount == 0 ? i : i / this.myColCount;
    }

    int i2c(int i) {
        return this.myColCount == 0 ? 0 : i % this.myColCount;
    }
}

