/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanArrayReductionBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class BooleanArrayBuf
extends BooleanBuf {
    boolean[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public BooleanArrayBuf(boolean[] theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public boolean get(int i) {
        return this.myArray[this.myArrayOffset + i * this.myStride];
    }

    @Override
    public void put(int i, boolean item) {
        this.myArray[this.myArrayOffset + i * this.myStride] = item;
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof BooleanArrayBuf) {
                BooleanArrayBuf src = (BooleanArrayBuf)theSrc;
                Arrays.copy(src.myArray, src.myRange, this.myArray, this.myRange);
            } else {
                BooleanBuf.defaultCopy((BooleanBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new BooleanArrayReductionBuf(this.myArray, this.myRange, (BooleanOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 1) {
            buffer.put(this.myArray[off] ? (byte)1 : 0);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray[off] = buffer.get() != 0;
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

