/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.ChannelClosedException;
import edu.rit.mp.IORequest;
import edu.rit.mp.NetworkChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;

class NetworkChannelSendThread
extends Thread {
    private NetworkChannel myNetworkChannel;
    private SocketChannel mySocketChannel;
    private LinkedBlockingQueue<IORequest> myOutgoingQueue;
    private ByteBuffer myByteBuffer;

    NetworkChannelSendThread(NetworkChannel theNetworkChannel, SocketChannel theSocketChannel, LinkedBlockingQueue<IORequest> theOutgoingQueue) {
        this.myNetworkChannel = theNetworkChannel;
        this.mySocketChannel = theSocketChannel;
        this.myOutgoingQueue = theOutgoingQueue;
        this.myByteBuffer = ByteBuffer.allocateDirect(29200);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        IORequest iorequest = null;
        Buf buf = null;
        while (true) {
            try {
                while (true) {
                    iorequest = this.myOutgoingQueue.take();
                    buf = iorequest.myBuf;
                    buf.preSend();
                    this.myByteBuffer.clear();
                    int msglength = buf.myMessageLength;
                    this.myByteBuffer.putInt(30144596);
                    this.myByteBuffer.putInt(iorequest.myTagLb);
                    this.myByteBuffer.put(buf.myMessageType);
                    this.myByteBuffer.putInt(msglength);
                    for (int i = 0; i < msglength; i += buf.sendItems(i, this.myByteBuffer)) {
                        this.myByteBuffer.flip();
                        this.mySocketChannel.write(this.myByteBuffer);
                        this.myByteBuffer.compact();
                    }
                    this.myByteBuffer.flip();
                    while (this.myByteBuffer.hasRemaining()) {
                        this.mySocketChannel.write(this.myByteBuffer);
                        this.myByteBuffer.compact();
                        this.myByteBuffer.flip();
                    }
                    buf.postSend();
                    iorequest.reportSuccess();
                    iorequest = null;
                    buf = null;
                }
            }
            catch (IOException exc) {
                if (iorequest == null) continue;
                iorequest.reportFailure(exc);
                continue;
            }
            catch (InterruptedException exc) {
                ChannelClosedException exc2 = new ChannelClosedException("Channel closed");
                if (iorequest != null) {
                    iorequest.reportFailure(exc2);
                }
                while ((iorequest = this.myOutgoingQueue.poll()) != null) {
                    iorequest.reportFailure(exc2);
                }
            }
            catch (RuntimeException exc) {
                if (iorequest == null) continue;
                iorequest.reportFailure(exc);
                continue;
            }
            catch (Error exc) {
                if (iorequest == null) continue;
                iorequest.reportFailure(exc);
                continue;
            }
            break;
        }
        this.myNetworkChannel = null;
        this.mySocketChannel = null;
        this.myOutgoingQueue = null;
        this.myByteBuffer = null;
    }
}

