/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

class MPObjectInputStream
extends ObjectInputStream {
    private ClassLoader myClassLoader;

    public MPObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    public MPObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.myClassLoader = cl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException exc) {
            if (this.myClassLoader != null) {
                return Class.forName(desc.getName(), false, this.myClassLoader);
            }
            throw exc;
        }
    }
}

