/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyLongBuf;
import edu.rit.mp.buf.LongArrayBuf;
import edu.rit.mp.buf.LongArrayBuf_1;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.mp.buf.LongMatrixBuf;
import edu.rit.mp.buf.LongMatrixBuf_1;
import edu.rit.mp.buf.SharedLongArrayBuf;
import edu.rit.mp.buf.SharedLongArrayBuf_1;
import edu.rit.mp.buf.SharedLongBuf;
import edu.rit.pj.reduction.SharedLong;
import edu.rit.pj.reduction.SharedLongArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class LongBuf
extends Buf {
    protected LongBuf(int theLength) {
        super((byte)5, theLength);
    }

    public static LongBuf emptyBuffer() {
        return new EmptyLongBuf();
    }

    public static LongItemBuf buffer() {
        return new LongItemBuf();
    }

    public static LongItemBuf buffer(long item) {
        return new LongItemBuf(item);
    }

    public static LongBuf buffer(long[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("LongBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new LongArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static LongBuf sliceBuffer(long[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("LongBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("LongBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new LongArrayBuf_1(theArray, theRange);
        }
        return new LongArrayBuf(theArray, theRange);
    }

    public static LongBuf[] sliceBuffers(long[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        LongBuf[] result = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = LongBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static LongBuf buffer(long[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("LongBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new LongMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static LongBuf rowSliceBuffer(long[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("LongBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("LongBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new LongMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new LongMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static LongBuf[] rowSliceBuffers(long[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        LongBuf[] result = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = LongBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static LongBuf colSliceBuffer(long[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("LongBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("LongBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new LongMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new LongMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static LongBuf[] colSliceBuffers(long[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        LongBuf[] result = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = LongBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static LongBuf patchBuffer(long[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("LongBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("LongBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("LongBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new LongMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new LongMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static LongBuf[] patchBuffers(long[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        LongBuf[] result = new LongBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = LongBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static LongBuf buffer(SharedLong item) {
        if (item == null) {
            throw new NullPointerException("LongBuf.buffer(): item is null");
        }
        return new SharedLongBuf(item);
    }

    public static LongBuf buffer(SharedLongArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("LongBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedLongArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static LongBuf sliceBuffer(SharedLongArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("LongBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("LongBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedLongArrayBuf_1(theArray, theRange);
        }
        return new SharedLongArrayBuf(theArray, theRange);
    }

    public static LongBuf[] sliceBuffers(SharedLongArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        LongBuf[] result = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = LongBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract long get(int var1);

    public abstract void put(int var1, long var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            LongBuf.defaultCopy((LongBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        long value = item == null ? 0L : (Long)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return LongBuf.buffer(new long[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 8);
        buffer.position(buffer.position() + 8 * n);
        return n;
    }

    protected static void defaultCopy(LongBuf theSrc, LongBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

