/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyIntegerBuf;
import edu.rit.mp.buf.IntegerArrayBuf;
import edu.rit.mp.buf.IntegerArrayBuf_1;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.mp.buf.IntegerMatrixBuf;
import edu.rit.mp.buf.IntegerMatrixBuf_1;
import edu.rit.mp.buf.SharedIntegerArrayBuf;
import edu.rit.mp.buf.SharedIntegerArrayBuf_1;
import edu.rit.mp.buf.SharedIntegerBuf;
import edu.rit.pj.reduction.SharedInteger;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class IntegerBuf
extends Buf {
    protected IntegerBuf(int theLength) {
        super((byte)4, theLength);
    }

    public static IntegerBuf emptyBuffer() {
        return new EmptyIntegerBuf();
    }

    public static IntegerItemBuf buffer() {
        return new IntegerItemBuf();
    }

    public static IntegerItemBuf buffer(int item) {
        return new IntegerItemBuf(item);
    }

    public static IntegerBuf buffer(int[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("IntegerBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new IntegerArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static IntegerBuf sliceBuffer(int[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("IntegerBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("IntegerBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new IntegerArrayBuf_1(theArray, theRange);
        }
        return new IntegerArrayBuf(theArray, theRange);
    }

    public static IntegerBuf[] sliceBuffers(int[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        IntegerBuf[] result = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = IntegerBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static IntegerBuf buffer(int[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("IntegerBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new IntegerMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static IntegerBuf rowSliceBuffer(int[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("IntegerBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("IntegerBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new IntegerMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new IntegerMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static IntegerBuf[] rowSliceBuffers(int[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        IntegerBuf[] result = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = IntegerBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static IntegerBuf colSliceBuffer(int[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("IntegerBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("IntegerBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new IntegerMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new IntegerMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static IntegerBuf[] colSliceBuffers(int[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        IntegerBuf[] result = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = IntegerBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static IntegerBuf patchBuffer(int[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("IntegerBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("IntegerBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("IntegerBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new IntegerMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new IntegerMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static IntegerBuf[] patchBuffers(int[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        IntegerBuf[] result = new IntegerBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = IntegerBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static IntegerBuf buffer(SharedInteger item) {
        if (item == null) {
            throw new NullPointerException("IntegerBuf.buffer(): item is null");
        }
        return new SharedIntegerBuf(item);
    }

    public static IntegerBuf buffer(SharedIntegerArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("IntegerBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedIntegerArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static IntegerBuf sliceBuffer(SharedIntegerArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("IntegerBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("IntegerBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedIntegerArrayBuf_1(theArray, theRange);
        }
        return new SharedIntegerArrayBuf(theArray, theRange);
    }

    public static IntegerBuf[] sliceBuffers(SharedIntegerArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        IntegerBuf[] result = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = IntegerBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract int get(int var1);

    public abstract void put(int var1, int var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            IntegerBuf.defaultCopy((IntegerBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        int value = item == null ? 0 : (Integer)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return IntegerBuf.buffer(new int[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 4);
        buffer.position(buffer.position() + 4 * n);
        return n;
    }

    protected static void defaultCopy(IntegerBuf theSrc, IntegerBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

