/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.Status;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;

public class IORequest {
    protected Channel myChannel;
    protected int myTagLb;
    protected int myTagUb;
    protected Buf myBuf;
    protected Status myStatus;
    IOException myIOException;
    RuntimeException myRuntimeException;
    Error myError;
    int myState = 0;
    static final int PENDING = 0;
    static final int SUCCEEDED = 1;
    static final int FAILED = 2;

    void initialize(Channel theChannel, int theTagLb, int theTagUb, Buf theBuf) {
        this.myChannel = theChannel;
        this.myTagLb = theTagLb;
        this.myTagUb = theTagUb;
        this.myBuf = theBuf;
        this.myStatus = null;
        this.myIOException = null;
        this.myRuntimeException = null;
        this.myError = null;
        this.myState = 0;
    }

    public synchronized boolean isFinished() throws IOException {
        if (this.myState == 0) {
            return false;
        }
        this.rethrow("IORequest: Exception during send or receive");
        return true;
    }

    public synchronized Status waitForFinish() throws IOException {
        try {
            while (this.myState == 0) {
                this.wait();
            }
            this.rethrow("IORequest: Exception during send or receive");
            return this.myStatus;
        }
        catch (InterruptedException exc) {
            InterruptedIOException exc2 = new InterruptedIOException("IORequest: waitForFinish() interrupted");
            exc2.initCause(exc);
            throw exc2;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IORequest(myChannel=");
        b.append(this.myChannel);
        b.append(",myTagLb=");
        b.append(this.myTagLb);
        b.append(",myTagUb=");
        b.append(this.myTagUb);
        b.append(",myBuf=");
        b.append(this.myBuf);
        b.append(",myState=");
        b.append(this.myState);
        b.append(")");
        return b.toString();
    }

    boolean match(IORequest that) {
        return (this.myChannel == null || that.myChannel == null || this.myChannel == that.myChannel) && this.myTagLb <= that.myTagLb && that.myTagLb <= this.myTagUb && this.myBuf.myMessageType == that.myBuf.myMessageType;
    }

    boolean match(Channel channel, int tag, byte type) {
        return (this.myChannel == null || channel == null || this.myChannel == channel) && this.myTagLb <= tag && tag <= this.myTagUb && this.myBuf.myMessageType == type;
    }

    protected synchronized void reportSuccess() {
        this.myState = 1;
        this.notifyAll();
    }

    protected synchronized void reportFailure(IOException theIOException) {
        this.myIOException = theIOException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(RuntimeException theRuntimeException) {
        this.myRuntimeException = theRuntimeException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(Error theError) {
        this.myError = theError;
        this.myState = 2;
        this.notifyAll();
    }

    private void rethrow(String msg) throws IOException {
        if (this.myIOException != null) {
            this.rethrowIOException(msg);
        } else if (this.myRuntimeException != null) {
            this.rethrowRuntimeException(msg);
        } else if (this.myError != null) {
            this.rethrowError(msg);
        }
    }

    private void rethrowIOException(String msg) throws IOException {
        IOException exc2 = null;
        try {
            Class<?> excClass = this.myIOException.getClass();
            Constructor<?> excConstructor = excClass.getConstructor(String.class);
            exc2 = (IOException)excConstructor.newInstance(msg);
        }
        catch (Throwable exc) {
            exc2 = new IOException(msg);
        }
        exc2.initCause(this.myIOException);
        throw exc2;
    }

    private void rethrowRuntimeException(String msg) {
        RuntimeException exc2 = null;
        try {
            Class<?> excClass = this.myRuntimeException.getClass();
            Constructor<?> excConstructor = excClass.getConstructor(String.class);
            exc2 = (RuntimeException)excConstructor.newInstance(msg);
        }
        catch (Throwable exc) {
            exc2 = new RuntimeException(msg);
        }
        exc2.initCause(this.myRuntimeException);
        throw exc2;
    }

    private void rethrowError(String msg) {
        Error exc2 = null;
        try {
            Class<?> excClass = this.myError.getClass();
            Constructor<?> excConstructor = excClass.getConstructor(String.class);
            exc2 = (Error)excConstructor.newInstance(msg);
        }
        catch (Throwable exc) {
            exc2 = new Error(msg);
        }
        exc2.initCause(this.myError);
        throw exc2;
    }
}

