/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import edu.rit.mp.LoopbackChannel;
import edu.rit.mp.NetworkChannel;
import edu.rit.mp.Status;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import edu.rit.util.Range;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ChannelGroup {
    int myChannelGroupId;
    ServerSocketChannel myServerSocketChannel;
    IORequestList myIORequestList;
    ClassLoader myClassLoader;
    LoopbackChannel myLoopbackChannel;
    List<Channel> myChannelList;
    AcceptThread myAcceptThread;
    ConnectListener myConnectListener;
    Logger myLogger;
    TimerThread myTimerThread;

    public ChannelGroup() {
        this(new PrintStreamLogger());
    }

    public ChannelGroup(InetSocketAddress theListenAddress) throws IOException {
        this(theListenAddress, (Logger)new PrintStreamLogger());
    }

    public ChannelGroup(ServerSocketChannel theServerSocketChannel) throws IOException {
        this(theServerSocketChannel, (Logger)new PrintStreamLogger());
    }

    public ChannelGroup(Logger theLogger) {
        if (theLogger == null) {
            throw new NullPointerException("ChannelGroup(): theLogger is null");
        }
        this.myIORequestList = new IORequestList();
        this.myLoopbackChannel = new LoopbackChannel(this);
        this.myChannelList = new LinkedList<Channel>();
        this.myChannelList.add(this.myLoopbackChannel);
        this.myLogger = theLogger;
        this.myTimerThread = new TimerThread();
        this.myTimerThread.setDaemon(true);
        this.myTimerThread.start();
    }

    public ChannelGroup(InetSocketAddress theListenAddress, Logger theLogger) throws IOException {
        this(theLogger);
        this.listen(theListenAddress);
    }

    public ChannelGroup(ServerSocketChannel theServerSocketChannel, Logger theLogger) throws IOException {
        this(theLogger);
        this.listen(theServerSocketChannel);
    }

    public void setChannelGroupId(int theChannelGroupId) {
        this.myChannelGroupId = theChannelGroupId;
    }

    public int getChannelGroupId() {
        return this.myChannelGroupId;
    }

    public synchronized InetSocketAddress listenAddress() {
        return this.myServerSocketChannel == null ? null : (InetSocketAddress)this.myServerSocketChannel.socket().getLocalSocketAddress();
    }

    public synchronized void listen(InetSocketAddress theListenAddress) throws IOException {
        if (theListenAddress == null) {
            throw new NullPointerException("ChannelGroup.listen(): theListenAddress is null");
        }
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.socket().bind(theListenAddress);
        this.listen(channel);
    }

    public synchronized void listen(ServerSocketChannel theServerSocketChannel) throws IOException {
        if (theServerSocketChannel == null) {
            throw new NullPointerException("ChannelGroup.listen(): theServerSocketChannel is null");
        }
        if (!theServerSocketChannel.socket().isBound()) {
            throw new IOException("ChannelGroup.listen(): theServerSocketChannel is not bound");
        }
        if (this.myAcceptThread != null) {
            throw new IllegalStateException("ChannelGroup.listen(): Listening has already started");
        }
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.listen(): Channel group closed");
        }
        this.myServerSocketChannel = theServerSocketChannel;
    }

    public synchronized void setConnectListener(ConnectListener theConnectListener) {
        this.myConnectListener = theConnectListener;
    }

    public synchronized void startListening() {
        if (this.myServerSocketChannel == null) {
            throw new IllegalStateException("ChannelGroup.startListening(): No server socket channel");
        }
        if (this.myAcceptThread != null) {
            throw new IllegalStateException("ChannelGroup.listen(): Listening has already started");
        }
        this.myAcceptThread = new AcceptThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect(InetSocketAddress theFarEndAddress) throws IOException {
        ChannelGroup channelGroup = this;
        synchronized (channelGroup) {
            if (this.myIORequestList == null) {
                throw new IOException("ChannelGroup.connect(): Channel group closed");
            }
        }
        SocketChannel connection = null;
        try {
            connection = SocketChannel.open(theFarEndAddress);
            return this.nearEndConnect(connection);
        }
        catch (IOException exc) {
            Thread.interrupted();
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw exc;
        }
    }

    public synchronized Channel loopbackChannel() {
        return this.myLoopbackChannel;
    }

    public void send(Channel theChannel, Buf theSrc) throws IOException {
        IORequest req = new IORequest();
        this.sendNoWait(theChannel, 0, theSrc, req);
        req.waitForFinish();
    }

    public void send(Channel theChannel, int theTag, Buf theSrc) throws IOException {
        IORequest req = new IORequest();
        this.sendNoWait(theChannel, theTag, theSrc, req);
        req.waitForFinish();
    }

    public void sendNoWait(Channel theChannel, Buf theSrc, IORequest theIORequest) throws IOException {
        this.sendNoWait(theChannel, 0, theSrc, theIORequest);
    }

    public void sendNoWait(Channel theChannel, int theTag, Buf theSrc, IORequest theIORequest) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.sendNoWait(): Channel group closed");
        }
        if (theSrc == null) {
            throw new NullPointerException("ChannelGroup.sendNoWait(): Source buffer is null");
        }
        theIORequest.initialize(theChannel, theTag, theTag, theSrc);
        theChannel.send(theIORequest);
    }

    public Status receive(Channel theChannel, Buf theDst) throws IOException {
        IORequest req = new IORequest();
        this.receiveNoWait(theChannel, 0, 0, theDst, req);
        return req.waitForFinish();
    }

    public Status receive(Channel theChannel, int theTag, Buf theDst) throws IOException {
        IORequest req = new IORequest();
        this.receiveNoWait(theChannel, theTag, theTag, theDst, req);
        return req.waitForFinish();
    }

    public Status receive(Channel theChannel, Range theTagRange, Buf theDst) throws IOException {
        IORequest req = new IORequest();
        if (theTagRange == null) {
            this.receiveNoWait(theChannel, Integer.MIN_VALUE, Integer.MAX_VALUE, theDst, req);
        } else {
            this.receiveNoWait(theChannel, theTagRange.lb(), theTagRange.ub(), theDst, req);
        }
        return req.waitForFinish();
    }

    public void receiveNoWait(Channel theChannel, Buf theDst, IORequest theIORequest) throws IOException {
        this.receiveNoWait(theChannel, 0, 0, theDst, theIORequest);
    }

    public void receiveNoWait(Channel theChannel, int theTag, Buf theDst, IORequest theIORequest) throws IOException {
        this.receiveNoWait(theChannel, theTag, theTag, theDst, theIORequest);
    }

    public void receiveNoWait(Channel theChannel, Range theTagRange, Buf theDst, IORequest theIORequest) throws IOException {
        if (theTagRange == null) {
            this.receiveNoWait(theChannel, Integer.MIN_VALUE, Integer.MAX_VALUE, theDst, theIORequest);
        } else {
            this.receiveNoWait(theChannel, theTagRange.lb(), theTagRange.ub(), theDst, theIORequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveNoWait(Channel theChannel, int theTagLb, int theTagUb, Buf theDst, IORequest theIORequest) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.receiveNoWait(): Channel group closed");
        }
        if (theDst == null) {
            throw new NullPointerException("ChannelGroup.receiveNoWait(): Destination buffer is null");
        }
        if (theChannel != null) {
            Channel channel = theChannel;
            synchronized (channel) {
                if (theChannel.myReadState == 1) {
                    throw new IOException("ChannelGroup.receiveNoWait(): Channel closed");
                }
            }
        }
        theIORequest.initialize(theChannel, theTagLb, theTagUb, theDst);
        this.myIORequestList.add(theIORequest);
    }

    public synchronized void setAlternateClassLoader(ClassLoader theClassLoader) {
        this.myClassLoader = theClassLoader;
    }

    public synchronized void close() {
        if (this.myServerSocketChannel != null) {
            try {
                this.myServerSocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myChannelList != null) {
            while (!this.myChannelList.isEmpty()) {
                this.myChannelList.get(0).close();
            }
        }
        if (this.myIORequestList != null) {
            this.myIORequestList.reportFailure(new ChannelGroupClosedException("Channel group closed"));
        }
        this.myServerSocketChannel = null;
        this.myIORequestList = null;
        this.myClassLoader = null;
        this.myLoopbackChannel = null;
        this.myChannelList = null;
        this.myAcceptThread = null;
    }

    public void dump(PrintStream out, String prefix) {
        out.println(prefix + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        out.println(prefix + "myChannelGroupId = " + this.myChannelGroupId);
        out.println(prefix + "myServerSocketChannel = " + String.valueOf(this.myServerSocketChannel));
        out.println(prefix + "myIORequestList:");
        this.myIORequestList.dump(out, prefix + "\t");
        out.println(prefix + "myClassLoader = " + String.valueOf(this.myClassLoader));
        out.println(prefix + "myLoopbackChannel = " + String.valueOf(this.myLoopbackChannel));
        out.println(prefix + "myChannelList:");
        out.println(prefix + "\t" + this.myChannelList.size() + " entries");
        for (Channel c : this.myChannelList) {
            c.dump(out, prefix + "\t");
        }
        out.println(prefix + "myAcceptThread = " + String.valueOf(this.myAcceptThread));
        out.println(prefix + "myConnectListener = " + String.valueOf(this.myConnectListener));
        out.println(prefix + "myLogger = " + String.valueOf(this.myLogger));
        out.println(prefix + "myTimerThread = " + String.valueOf(this.myTimerThread));
    }

    Channel nearEndConnect(SocketChannel theSocketChannel) throws IOException {
        Socket socket = theSocketChannel.socket();
        socket.setTcpNoDelay(true);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.myChannelGroupId);
        buf.flip();
        if (theSocketChannel.write(buf) != 4) {
            throw new IOException("ChannelGroup.nearEndConnect(): Cannot send channel group ID");
        }
        buf.clear();
        final Thread thread = Thread.currentThread();
        Timer timer = this.myTimerThread.createTimer(new TimerTask(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void action(Timer theTimer) {
                thread.interrupt();
            }
        });
        timer.start(30000L);
        if (theSocketChannel.read(buf) != 4) {
            throw new IOException("ChannelGroup.nearEndConnect(): Cannot receive channel group ID");
        }
        timer.stop();
        buf.flip();
        int farChannelGroupId = buf.getInt();
        Channel channel = this.createNetworkChannel(theSocketChannel, farChannelGroupId);
        if (this.myConnectListener != null) {
            this.myConnectListener.nearEndConnected(this, channel);
        }
        channel.start();
        return channel;
    }

    Channel farEndConnect(SocketChannel theSocketChannel) throws IOException {
        Socket socket = theSocketChannel.socket();
        socket.setTcpNoDelay(true);
        final Thread thread = Thread.currentThread();
        Timer timer = this.myTimerThread.createTimer(new TimerTask(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void action(Timer theTimer) {
                thread.interrupt();
            }
        });
        timer.start(30000L);
        try {
            ByteBuffer buf = ByteBuffer.allocate(4);
            if (theSocketChannel.read(buf) != 4) {
                throw new IOException("ChannelGroup.farEndConnect(): Cannot receive channel group ID");
            }
            timer.stop();
            buf.flip();
            int farChannelGroupId = buf.getInt();
            buf.clear();
            buf.putInt(this.myChannelGroupId);
            buf.flip();
            if (theSocketChannel.write(buf) != 4) {
                throw new IOException("ChannelGroup.farEndConnect(): Cannot send channel group ID");
            }
            Channel channel = this.createNetworkChannel(theSocketChannel, farChannelGroupId);
            if (this.myConnectListener != null) {
                this.myConnectListener.farEndConnected(this, channel);
            }
            channel.start();
            return channel;
        }
        catch (IOException exc) {
            timer.stop();
            throw exc;
        }
    }

    synchronized Channel createNetworkChannel(SocketChannel theSocketChannel, int theFarChannelGroupId) throws IOException {
        NetworkChannel channel = null;
        if (this.myIORequestList != null) {
            channel = new NetworkChannel(this, theSocketChannel, theFarChannelGroupId);
            this.myChannelList.add(channel);
        }
        return channel;
    }

    synchronized void removeChannel(Channel channel) {
        if (this.myChannelList != null) {
            this.myChannelList.remove(channel);
        }
    }

    private class AcceptThread
    extends Thread {
        final /* synthetic */ ChannelGroup this$0;

        public AcceptThread(ChannelGroup channelGroup) {
            ChannelGroup channelGroup2 = channelGroup;
            Objects.requireNonNull(channelGroup2);
            this.this$0 = channelGroup2;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                SocketChannel connection = null;
                try {
                    connection = this.this$0.myServerSocketChannel.accept();
                }
                catch (ClosedChannelException exc) {
                    this.this$0.myLogger.log("ChannelGroup: Channel closed", (Throwable)exc);
                    break;
                }
                catch (IOException exc) {
                    this.this$0.myLogger.log("ChannelGroup: I/O error while accepting connection", (Throwable)exc);
                    break;
                }
                if (connection == null) continue;
                try {
                    this.this$0.farEndConnect(connection);
                }
                catch (IOException exc) {
                    Thread.interrupted();
                    this.this$0.myLogger.log("ChannelGroup: I/O error while setting up channel", (Throwable)exc);
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

