/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;

public abstract class Channel {
    ChannelGroup myChannelGroup;
    IORequestList myIORequestList;
    Object myInfo;
    int myWriteState = 0;
    static final int WRITE_OPEN = 0;
    static final int WRITE_CLOSED = 1;
    int myReadState = 0;
    static final int READ_OPEN = 0;
    static final int READ_CLOSED = 1;

    Channel(ChannelGroup theChannelGroup) {
        this.myChannelGroup = theChannelGroup;
        this.myIORequestList = theChannelGroup.myIORequestList;
    }

    public ChannelGroup getChannelGroup() {
        return this.myChannelGroup;
    }

    public abstract int nearEndChannelGroupId();

    public abstract int farEndChannelGroupId();

    public abstract InetSocketAddress nearEndAddress();

    public abstract InetSocketAddress farEndAddress();

    public Object info() {
        return this.myInfo;
    }

    public void info(Object theInfo) {
        this.myInfo = theInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ChannelGroup channelGroup = this.myChannelGroup;
        synchronized (channelGroup) {
            Channel channel = this;
            synchronized (channel) {
                this.myChannelGroup.removeChannel(this);
                this.myWriteState = 1;
                this.myReadState = 1;
                this.subclassClose();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "(near=" + String.valueOf(this.nearEndAddress()) + ",far=" + String.valueOf(this.farEndAddress()) + ")";
    }

    public void dump(PrintStream out, String prefix) {
        out.println(prefix + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        out.println(prefix + "myChannelGroup = " + String.valueOf(this.myChannelGroup));
        out.println(prefix + "myIORequestList = " + String.valueOf(this.myIORequestList));
        out.println(prefix + "myInfo = " + String.valueOf(this.myInfo));
        out.println(prefix + "myWriteState = " + (this.myWriteState == 0 ? "WRITE_OPEN" : "WRITE_CLOSED"));
        out.println(prefix + "myReadState = " + (this.myReadState == 0 ? "READ_OPEN" : "READ_CLOSED"));
        out.println(prefix + "nearEndChannelGroupId() = " + this.nearEndChannelGroupId());
        out.println(prefix + "farEndChannelGroupId() = " + this.farEndChannelGroupId());
        out.println(prefix + "nearEndAddress() = " + String.valueOf(this.nearEndAddress()));
        out.println(prefix + "farEndAddress() = " + String.valueOf(this.farEndAddress()));
    }

    void start() {
    }

    abstract void send(IORequest var1) throws IOException;

    void subclassClose() {
    }
}

