/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanArrayBuf;
import edu.rit.mp.buf.BooleanArrayBuf_1;
import edu.rit.mp.buf.BooleanItemBuf;
import edu.rit.mp.buf.BooleanMatrixBuf;
import edu.rit.mp.buf.BooleanMatrixBuf_1;
import edu.rit.mp.buf.EmptyBooleanBuf;
import edu.rit.mp.buf.SharedBooleanArrayBuf;
import edu.rit.mp.buf.SharedBooleanArrayBuf_1;
import edu.rit.mp.buf.SharedBooleanBuf;
import edu.rit.pj.reduction.SharedBoolean;
import edu.rit.pj.reduction.SharedBooleanArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class BooleanBuf
extends Buf {
    protected BooleanBuf(int theLength) {
        super((byte)1, theLength);
    }

    public static BooleanBuf emptyBuffer() {
        return new EmptyBooleanBuf();
    }

    public static BooleanItemBuf buffer() {
        return new BooleanItemBuf();
    }

    public static BooleanItemBuf buffer(boolean item) {
        return new BooleanItemBuf(item);
    }

    public static BooleanBuf buffer(boolean[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("BooleanBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new BooleanArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static BooleanBuf sliceBuffer(boolean[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("BooleanBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("BooleanBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new BooleanArrayBuf_1(theArray, theRange);
        }
        return new BooleanArrayBuf(theArray, theRange);
    }

    public static BooleanBuf[] sliceBuffers(boolean[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        BooleanBuf[] result = new BooleanBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = BooleanBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static BooleanBuf buffer(boolean[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("BooleanBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new BooleanMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static BooleanBuf rowSliceBuffer(boolean[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("BooleanBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("BooleanBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new BooleanMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new BooleanMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static BooleanBuf[] rowSliceBuffers(boolean[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        BooleanBuf[] result = new BooleanBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = BooleanBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static BooleanBuf colSliceBuffer(boolean[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("BooleanBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("BooleanBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new BooleanMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new BooleanMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static BooleanBuf[] colSliceBuffers(boolean[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        BooleanBuf[] result = new BooleanBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = BooleanBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static BooleanBuf patchBuffer(boolean[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("BooleanBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("BooleanBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("BooleanBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new BooleanMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new BooleanMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static BooleanBuf[] patchBuffers(boolean[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        BooleanBuf[] result = new BooleanBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = BooleanBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static BooleanBuf buffer(SharedBoolean item) {
        if (item == null) {
            throw new NullPointerException("BooleanBuf.buffer(): item is null");
        }
        return new SharedBooleanBuf(item);
    }

    public static BooleanBuf buffer(SharedBooleanArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("BooleanBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedBooleanArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static BooleanBuf sliceBuffer(SharedBooleanArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("BooleanBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("BooleanBuf.sliceBuffer(): theArray row index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedBooleanArrayBuf_1(theArray, theRange);
        }
        return new SharedBooleanArrayBuf(theArray, theRange);
    }

    public static BooleanBuf[] sliceBuffers(SharedBooleanArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        BooleanBuf[] result = new BooleanBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = BooleanBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract boolean get(int var1);

    public abstract void put(int var1, boolean var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            BooleanBuf.defaultCopy((BooleanBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        boolean value = item == null ? false : (Boolean)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return BooleanBuf.buffer(new boolean[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining());
        buffer.position(buffer.position() + n);
        return n;
    }

    protected static void defaultCopy(BooleanBuf theSrc, BooleanBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

