/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import java.io.InputStream;
import java.io.PrintStream;

public class Stdio {
    private static ThreadLocal<InputStream> in = new ThreadLocal<InputStream>(){

        @Override
        protected InputStream initialValue() {
            return System.in;
        }
    };
    private static ThreadLocal<PrintStream> out = new ThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.out;
        }
    };
    private static ThreadLocal<PrintStream> err = new ThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.err;
        }
    };

    private Stdio() {
    }

    public static InputStream in() {
        return in.get();
    }

    public static PrintStream out() {
        return out.get();
    }

    public static PrintStream err() {
        return err.get();
    }

    public static void in(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("Stdio.in(): stream is null");
        }
        in.set(stream);
    }

    public static void out(PrintStream stream) {
        if (stream == null) {
            throw new NullPointerException("Stdio.out(): stream is null");
        }
        out.set(stream);
    }

    public static void err(PrintStream stream) {
        if (stream == null) {
            throw new NullPointerException("Stdio.err(): stream is null");
        }
        err.set(stream);
    }
}

