/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends FilterOutputStream {
    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    public void writeInt(int v) throws IOException {
        if (-64 <= v && v <= 63) {
            this.out.write(v & 0x7F);
        } else if (-8192 <= v && v <= 8191) {
            this.out.write(v >> 8 & 0x3F | 0x80);
            this.out.write(v);
        } else if (-1048576 <= v && v <= 1048575) {
            this.out.write(v >> 16 & 0x1F | 0xC0);
            this.out.write(v >> 8);
            this.out.write(v);
        } else if (-134217728 <= v && v <= 0x7FFFFFF) {
            this.out.write(v >> 24 & 0xF | 0xE0);
            this.out.write(v >> 16);
            this.out.write(v >> 8);
            this.out.write(v);
        } else {
            this.out.write(v >> 32 & 0xF | 0xF0);
            this.out.write(v >> 24);
            this.out.write(v >> 16);
            this.out.write(v >> 8);
            this.out.write(v);
        }
    }

    public void writeUnsignedInt(int v) throws IOException {
        if (0 <= v && v <= 127) {
            this.out.write(v);
        } else if (128 <= v && v <= 16383) {
            this.out.write(v >> 8 | 0x80);
            this.out.write(v);
        } else if (16384 <= v && v <= 0x1FFFFF) {
            this.out.write(v >> 16 | 0xC0);
            this.out.write(v >> 8);
            this.out.write(v);
        } else if (0x200000 <= v && v <= 0xFFFFFFF) {
            this.out.write(v >> 24 | 0xE0);
            this.out.write(v >> 16);
            this.out.write(v >> 8);
            this.out.write(v);
        } else {
            this.out.write(240);
            this.out.write(v >> 24);
            this.out.write(v >> 16);
            this.out.write(v >> 8);
            this.out.write(v);
        }
    }

    public void writeLong(long v) throws IOException {
        if (-64L <= v && v <= 63L) {
            this.out.write((int)v & 0x7F);
        } else if (-8192L <= v && v <= 8191L) {
            this.out.write((int)(v >> 8) & 0x3F | 0x80);
            this.out.write((int)v);
        } else if (-1048576L <= v && v <= 1048575L) {
            this.out.write((int)(v >> 16) & 0x1F | 0xC0);
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (-134217728L <= v && v <= 0x7FFFFFFL) {
            this.out.write((int)(v >> 24) & 0xF | 0xE0);
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (-17179869184L <= v && v <= 0x3FFFFFFFFL) {
            this.out.write((int)(v >> 32) & 7 | 0xF0);
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (-2199023255552L <= v && v <= 0x1FFFFFFFFFFL) {
            this.out.write((int)(v >> 40) & 3 | 0xF8);
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (-281474976710656L <= v && v <= 0x1000000000000L) {
            this.out.write((int)(v >> 48) & 1 | 0xFC);
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (-36028797018963968L <= v && v <= 0x80000000000000L) {
            this.out.write(254);
            this.out.write((int)(v >> 48));
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else {
            this.out.write(255);
            this.out.write((int)(v >> 56));
            this.out.write((int)(v >> 48));
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        }
    }

    public void writeUnsignedLong(long v) throws IOException {
        if (0L <= v && v <= 127L) {
            this.out.write((int)v);
        } else if (128L <= v && v <= 16383L) {
            this.out.write((int)(v >> 8) | 0x80);
            this.out.write((int)v);
        } else if (16384L <= v && v <= 0x1FFFFFL) {
            this.out.write((int)(v >> 16) | 0xC0);
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (0x200000L <= v && v <= 0xFFFFFFFL) {
            this.out.write((int)(v >> 24) | 0xE0);
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (0x10000000L <= v && v <= 0x7FFFFFFFFL) {
            this.out.write((int)(v >> 32) | 0xF0);
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (0x800000000L <= v && v <= 0x3FFFFFFFFFFL) {
            this.out.write((int)(v >> 40) | 0xF8);
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (0x40000000000L <= v && v <= 0x1FFFFFFFFFFFFL) {
            this.out.write((int)(v >> 48) | 0xFC);
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else if (0x2000000000000L <= v && v <= 0xFFFFFFFFFFFFFFL) {
            this.out.write(254);
            this.out.write((int)(v >> 48));
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        } else {
            this.out.write(255);
            this.out.write((int)(v >> 56));
            this.out.write((int)(v >> 48));
            this.out.write((int)(v >> 40));
            this.out.write((int)(v >> 32));
            this.out.write((int)(v >> 24));
            this.out.write((int)(v >> 16));
            this.out.write((int)(v >> 8));
            this.out.write((int)v);
        }
    }

    public void writeFloat(float v) throws IOException {
        int x = Float.floatToRawIntBits(v);
        this.out.write(x >> 24);
        this.out.write(x >> 16);
        this.out.write(x >> 8);
        this.out.write(x);
    }

    public void writeDouble(double v) throws IOException {
        long x = Double.doubleToRawLongBits(v);
        this.out.write((int)(x >> 56));
        this.out.write((int)(x >> 48));
        this.out.write((int)(x >> 40));
        this.out.write((int)(x >> 32));
        this.out.write((int)(x >> 24));
        this.out.write((int)(x >> 16));
        this.out.write((int)(x >> 8));
        this.out.write((int)x);
    }

    public void writeString(String v) throws IOException {
        int n = v.length();
        this.writeUnsignedInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeUnsignedInt(v.charAt(i));
        }
    }
}

