/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class HttpResponse {
    private Socket mySocket;
    private Status myStatusCode = Status.STATUS_200_OK;
    private String myContentType = "text/html";
    private Charset myCharset = Charset.defaultCharset();
    private Map<String, String> myHeaderMap = new HashMap<String, String>();
    private PrintWriter myPrintWriter;

    public HttpResponse(Socket theSocket) {
        if (theSocket == null) {
            throw new NullPointerException("HttpResponse(): theSocket is null");
        }
        this.mySocket = theSocket;
        this.recordContentType();
    }

    public void setStatusCode(Status theStatusCode) {
        if (theStatusCode == null) {
            throw new NullPointerException("HttpResponse.setStatusCode(): theStatusCode is null");
        }
        if (this.myPrintWriter != null) {
            throw new IllegalStateException("HttpResponse.setStatusCode(): Headers already written");
        }
        this.myStatusCode = theStatusCode;
    }

    public void setContentType(@Nullable String theContentType) {
        if (theContentType == null) {
            throw new NullPointerException("HttpResponse.setContentType(): theContentType is null");
        }
        if (theContentType.isEmpty()) {
            throw new IllegalArgumentException("HttpResponse.setContentType(): theContentType is zero length");
        }
        if (this.myPrintWriter != null) {
            throw new IllegalStateException("HttpResponse.setContentType(): Headers already written");
        }
        this.myContentType = theContentType;
        this.recordContentType();
    }

    public void setCharset(Charset theCharset) {
        if (theCharset == null) {
            throw new NullPointerException("HttpResponse.setCharset(): theCharset is null");
        }
        if (this.myPrintWriter != null) {
            throw new IllegalStateException("HttpResponse.setCharset(): Headers already written");
        }
        this.myCharset = theCharset;
        this.recordContentType();
    }

    public void setContentLength(int theContentLength) {
        if (theContentLength < 0) {
            throw new IllegalArgumentException("HttpResponse.setContentLength(): theContentLength < 0");
        }
        if (this.myPrintWriter != null) {
            throw new IllegalStateException("HttpResponse.setContentLength(): Headers already written");
        }
        this.myHeaderMap.put("Content-Length", "" + theContentLength);
    }

    public void setHeader(@Nullable String theHeaderName, @Nullable String theHeaderValue) {
        if (theHeaderName == null) {
            throw new NullPointerException("HttpResponse.setHeader(): theHeaderName is null");
        }
        if (theHeaderName.isEmpty()) {
            throw new IllegalArgumentException("HttpResponse.setHeader(): theHeaderName is zero length");
        }
        if (theHeaderValue == null) {
            throw new NullPointerException("HttpResponse.setHeader(): theHeaderValue is null");
        }
        if (theHeaderValue.isEmpty()) {
            throw new IllegalArgumentException("HttpResponse.setHeader(): theHeaderValue is zero length");
        }
        if (this.myPrintWriter != null) {
            throw new IllegalStateException("HttpResponse.setHeader(): Headers already written");
        }
        this.myHeaderMap.put(theHeaderName, theHeaderValue);
    }

    public PrintWriter getPrintWriter() throws IOException {
        return this.writeHeaders();
    }

    public void close() throws IOException {
        this.writeHeaders();
        this.myPrintWriter.close();
        this.mySocket.close();
    }

    private void recordContentType() {
        this.myHeaderMap.put("Content-Type", this.myContentType + "; charset=" + String.valueOf(this.myCharset));
    }

    private PrintWriter writeHeaders() throws IOException {
        if (this.myPrintWriter == null) {
            this.myPrintWriter = new PrintWriter(new OutputStreamWriter(this.mySocket.getOutputStream(), this.myCharset));
            this.myPrintWriter.write("HTTP/1.0 " + String.valueOf((Object)this.myStatusCode) + "\r\n");
            for (Map.Entry<String, String> entry : this.myHeaderMap.entrySet()) {
                this.myPrintWriter.write(entry.getKey() + ": " + entry.getValue() + "\r\n");
            }
            this.myPrintWriter.write("\r\n");
        }
        return this.myPrintWriter;
    }

    public static enum Status {
        STATUS_200_OK("200 OK"),
        STATUS_201_CREATED("201 Created"),
        STATUS_202_ACCEPTED("202 Accepted"),
        STATUS_204_NO_CONTENT("204 No content"),
        STATUS_301_MOVED_PERMANENTLY("301 Moved Permanently"),
        STATUS_302_MOVED_TEMPORARILY("302 Moved Temporarily"),
        STATUS_304_NOT_MODIFIED("304 Not Modified"),
        STATUS_400_BAD_REQUEST("400 Bad Request"),
        STATUS_401_UNAUTHORIZED("401 Unauthorized"),
        STATUS_403_FORBIDDEN("403 Forbidden"),
        STATUS_404_NOT_FOUND("404 Not Found"),
        STATUS_500_INTERNAL_SERVER_ERROR("500 Internal Server Error"),
        STATUS_501_NOT_IMPLEMENTED("501 Not Implemented"),
        STATUS_502_BAD_GATEWAY("502 Bad Gateway"),
        STATUS_503_SERVICE_UNAVAILABLE("503 Service Unavailable");

        private final String stringForm;

        private Status(String stringForm) {
            this.stringForm = stringForm;
        }

        public String toString() {
            return this.stringForm;
        }
    }
}

