/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;

public abstract class TabulatedFunction {
    protected PointerByReference pointer;

    public TabulatedFunction(PointerByReference pointer) {
        if (pointer == null || pointer.getValue() == null) {
            throw new IllegalArgumentException("Pointer cannot be null.");
        }
        this.pointer = pointer;
    }

    public abstract void destroy();

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public boolean getPeriodic() {
        int periodic = OpenMMLibrary.OpenMM_TabulatedFunction_getPeriodic((PointerByReference)this.pointer);
        return periodic == 1;
    }

    public int getUpdateCount() {
        return OpenMMLibrary.OpenMM_TabulatedFunction_getUpdateCount((PointerByReference)this.pointer);
    }
}

