/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.openmm.Force;
import ffx.openmm.VirtualSite;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class System {
    private PointerByReference pointer;
    private final Map<Pointer, Force> forceMap = new HashMap<Pointer, Force>();
    private final Map<Pointer, VirtualSite> virtualSiteMap = new HashMap<Pointer, VirtualSite>();

    public System() {
        this.pointer = OpenMMLibrary.OpenMM_System_create();
    }

    public System(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public int addConstraint(int particle1, int particle2, double distance) {
        return OpenMMLibrary.OpenMM_System_addConstraint((PointerByReference)this.pointer, (int)particle1, (int)particle2, (double)distance);
    }

    public int addForce(Force force) {
        if (force != null) {
            int forceIndex = OpenMMLibrary.OpenMM_System_addForce((PointerByReference)this.pointer, (PointerByReference)force.getPointer());
            force.setForceIndex(forceIndex);
            this.forceMap.put(force.getPointer().getValue(), force);
            return forceIndex;
        }
        return -1;
    }

    public int addParticle(double mass) {
        return OpenMMLibrary.OpenMM_System_addParticle((PointerByReference)this.pointer, (double)mass);
    }

    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_System_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getConstraintParameters(int index, IntByReference particle1, IntByReference particle2, DoubleByReference distance) {
        OpenMMLibrary.OpenMM_System_getConstraintParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (DoubleByReference)distance);
    }

    public void getConstraintParameters(int index, IntBuffer particle1, IntBuffer particle2, DoubleBuffer distance) {
        OpenMMLibrary.OpenMM_System_getConstraintParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2, (DoubleBuffer)distance);
    }

    public void getDefaultPeriodicBoxVectors(OpenMM_Vec3 a, OpenMM_Vec3 b, OpenMM_Vec3 c) {
        OpenMMLibrary.OpenMM_System_getDefaultPeriodicBoxVectors((PointerByReference)this.pointer, (OpenMM_Vec3)a, (OpenMM_Vec3)b, (OpenMM_Vec3)c);
    }

    public Force getForce(int index) {
        PointerByReference forcePointer = OpenMMLibrary.OpenMM_System_getForce((PointerByReference)this.pointer, (int)index);
        return this.forceMap.get(forcePointer.getValue());
    }

    public int getNumConstraints() {
        return OpenMMLibrary.OpenMM_System_getNumConstraints((PointerByReference)this.pointer);
    }

    public int getNumForces() {
        return OpenMMLibrary.OpenMM_System_getNumForces((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_System_getNumParticles((PointerByReference)this.pointer);
    }

    public double getParticleMass(int index) {
        return OpenMMLibrary.OpenMM_System_getParticleMass((PointerByReference)this.pointer, (int)index);
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public VirtualSite getVirtualSite(int index) {
        PointerByReference virtualSitePointer = OpenMMLibrary.OpenMM_System_getVirtualSite((PointerByReference)this.pointer, (int)index);
        return this.virtualSiteMap.get(virtualSitePointer.getValue());
    }

    public boolean isVirtualSite(int index) {
        int result = OpenMMLibrary.OpenMM_System_isVirtualSite((PointerByReference)this.pointer, (int)index);
        return result != 0;
    }

    public void removeConstraint(int index) {
        OpenMMLibrary.OpenMM_System_removeConstraint((PointerByReference)this.pointer, (int)index);
    }

    public void removeForce(int index) {
        Force force = this.getForce(index);
        this.forceMap.remove(force.getPointer().getValue());
        OpenMMLibrary.OpenMM_System_removeForce((PointerByReference)this.pointer, (int)index);
    }

    public void setConstraintParameters(int index, int particle1, int particle2, double distance) {
        OpenMMLibrary.OpenMM_System_setConstraintParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (double)distance);
    }

    public void setDefaultPeriodicBoxVectors(OpenMM_Vec3 a, OpenMM_Vec3 b, OpenMM_Vec3 c) {
        OpenMMLibrary.OpenMM_System_setDefaultPeriodicBoxVectors((PointerByReference)this.pointer, (OpenMM_Vec3)a, (OpenMM_Vec3)b, (OpenMM_Vec3)c);
    }

    public void setParticleMass(int index, double mass) {
        OpenMMLibrary.OpenMM_System_setParticleMass((PointerByReference)this.pointer, (int)index, (double)mass);
    }

    public void setPointer(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public void setVirtualSite(int index, VirtualSite virtualSite) {
        if (virtualSite != null) {
            this.virtualSiteMap.put(virtualSite.getPointer().getValue(), virtualSite);
        }
        OpenMMLibrary.OpenMM_System_setVirtualSite((PointerByReference)this.pointer, (int)index, (PointerByReference)virtualSite.getPointer());
    }

    public boolean usesPeriodicBoundaryConditions() {
        int result = OpenMMLibrary.OpenMM_System_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return result == 1;
    }
}

