/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;

public class StringArray {
    private PointerByReference pointer;

    public StringArray(int size) {
        this.pointer = OpenMMLibrary.OpenMM_StringArray_create((int)size);
    }

    public StringArray(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public void append(String string) {
        OpenMMLibrary.OpenMM_StringArray_append((PointerByReference)this.pointer, (String)string);
    }

    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_StringArray_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public String get(int i) {
        int size = this.getSize();
        if (i < 0 || i >= size) {
            return null;
        }
        Pointer string = OpenMMLibrary.OpenMM_StringArray_get((PointerByReference)this.pointer, (int)i);
        if (string == null) {
            return null;
        }
        return string.getString(0L);
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public int getSize() {
        return OpenMMLibrary.OpenMM_StringArray_getSize((PointerByReference)this.pointer);
    }

    public void resize(int size) {
        OpenMMLibrary.OpenMM_StringArray_resize((PointerByReference)this.pointer, (int)size);
    }

    public void set(int i, String string) {
        OpenMMLibrary.OpenMM_StringArray_set((PointerByReference)this.pointer, (int)i, (String)string);
    }
}

