/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class PeriodicTorsionForce
extends Force {
    public PeriodicTorsionForce() {
        super(OpenMMLibrary.OpenMM_PeriodicTorsionForce_create());
    }

    public int addTorsion(int particle1, int particle2, int particle3, int particle4, int periodicity, double phase, double k) {
        return OpenMMLibrary.OpenMM_PeriodicTorsionForce_addTorsion((PointerByReference)this.pointer, (int)particle1, (int)particle2, (int)particle3, (int)particle4, (int)periodicity, (double)phase, (double)k);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_PeriodicTorsionForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public int getNumTorsions() {
        return OpenMMLibrary.OpenMM_PeriodicTorsionForce_getNumTorsions((PointerByReference)this.pointer);
    }

    public void getTorsionParameters(int index, IntByReference particle1, IntByReference particle2, IntByReference particle3, IntByReference particle4, IntByReference periodicity, DoubleByReference phase, DoubleByReference k) {
        OpenMMLibrary.OpenMM_PeriodicTorsionForce_getTorsionParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (IntByReference)particle3, (IntByReference)particle4, (IntByReference)periodicity, (DoubleByReference)phase, (DoubleByReference)k);
    }

    public void getTorsionParameters(int index, IntBuffer particle1, IntBuffer particle2, IntBuffer particle3, IntBuffer particle4, IntBuffer periodicity, DoubleBuffer phase, DoubleBuffer k) {
        OpenMMLibrary.OpenMM_PeriodicTorsionForce_getTorsionParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2, (IntBuffer)particle3, (IntBuffer)particle4, (IntBuffer)periodicity, (DoubleBuffer)phase, (DoubleBuffer)k);
    }

    public void setTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, int periodicity, double phase, double k) {
        OpenMMLibrary.OpenMM_PeriodicTorsionForce_setTorsionParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (int)particle3, (int)particle4, (int)periodicity, (double)phase, (double)k);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_PeriodicTorsionForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_PeriodicTorsionForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_PeriodicTorsionForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

