/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;

public class GBSAOBCForce
extends Force {
    public GBSAOBCForce() {
        super(OpenMMLibrary.OpenMM_GBSAOBCForce_create());
    }

    public int addParticle(double charge, double radius, double scale) {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_addParticle((PointerByReference)this.pointer, (double)charge, (double)radius, (double)scale);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_GBSAOBCForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getCutoffDistance() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public int getNonbondedMethod() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getNumParticles((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, DoubleByReference charge, DoubleByReference radius, DoubleByReference scale) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)charge, (DoubleByReference)radius, (DoubleByReference)scale);
    }

    public void getParticleParameters(int index, DoubleBuffer charge, DoubleBuffer radius, DoubleBuffer scale) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (DoubleBuffer)charge, (DoubleBuffer)radius, (DoubleBuffer)scale);
    }

    public double getSoluteDielectric() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getSoluteDielectric((PointerByReference)this.pointer);
    }

    public double getSolventDielectric() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getSolventDielectric((PointerByReference)this.pointer);
    }

    public double getSurfaceAreaEnergy() {
        return OpenMMLibrary.OpenMM_GBSAOBCForce_getSurfaceAreaEnergy((PointerByReference)this.pointer);
    }

    public void setCutoffDistance(double distance) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setCutoffDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setNonbondedMethod(int method) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setParticleParameters(int index, double charge, double radius, double scale) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (double)charge, (double)radius, (double)scale);
    }

    public void setSoluteDielectric(double dielectric) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setSoluteDielectric((PointerByReference)this.pointer, (double)dielectric);
    }

    public void setSolventDielectric(double dielectric) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setSolventDielectric((PointerByReference)this.pointer, (double)dielectric);
    }

    public void setSurfaceAreaEnergy(double energy) {
        OpenMMLibrary.OpenMM_GBSAOBCForce_setSurfaceAreaEnergy((PointerByReference)this.pointer, (double)energy);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_GBSAOBCForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_GBSAOBCForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

