/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Integrator;
import java.nio.IntBuffer;

public class CustomIntegrator
extends Integrator {
    public CustomIntegrator(double dt) {
        super(OpenMMLibrary.OpenMM_CustomIntegrator_create((double)dt));
    }

    public int addComputeGlobal(String variable, String expression) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addComputeGlobal((PointerByReference)this.pointer, (String)variable, (String)expression);
    }

    public int addComputePerDof(String variable, String expression) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addComputePerDof((PointerByReference)this.pointer, (String)variable, (String)expression);
    }

    public int addComputeSum(String variable, String expression) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addComputeSum((PointerByReference)this.pointer, (String)variable, (String)expression);
    }

    public int addConstrainPositions() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addConstrainPositions((PointerByReference)this.pointer);
    }

    public int addConstrainVelocities() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addConstrainVelocities((PointerByReference)this.pointer);
    }

    public int addGlobalVariable(String name, double initialValue) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addGlobalVariable((PointerByReference)this.pointer, (String)name, (double)initialValue);
    }

    public int addPerDofVariable(String name, double initialValue) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addPerDofVariable((PointerByReference)this.pointer, (String)name, (double)initialValue);
    }

    public int addTabulatedFunction(String name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function);
    }

    public int addUpdateContextState() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_addUpdateContextState((PointerByReference)this.pointer);
    }

    public int beginIfBlock(String condition) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_beginIfBlock((PointerByReference)this.pointer, (String)condition);
    }

    public int beginWhileBlock(String condition) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_beginWhileBlock((PointerByReference)this.pointer, (String)condition);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomIntegrator_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public int endBlock() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_endBlock((PointerByReference)this.pointer);
    }

    public void getComputationStep(int index, IntByReference type, PointerByReference variable, PointerByReference expression) {
        OpenMMLibrary.OpenMM_CustomIntegrator_getComputationStep((PointerByReference)this.pointer, (int)index, (IntByReference)type, (PointerByReference)variable, (PointerByReference)expression);
    }

    public void getComputationStep(int index, IntBuffer type, PointerByReference variable, PointerByReference expression) {
        OpenMMLibrary.OpenMM_CustomIntegrator_getComputationStep((PointerByReference)this.pointer, (int)index, (IntBuffer)type, (PointerByReference)variable, (PointerByReference)expression);
    }

    public double getGlobalVariable(int index) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getGlobalVariable((PointerByReference)this.pointer, (int)index);
    }

    public double getGlobalVariableByName(String name) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getGlobalVariableByName((PointerByReference)this.pointer, (String)name);
    }

    public String getGlobalVariableName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomIntegrator_getGlobalVariableName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getKineticEnergyExpression() {
        Pointer p = OpenMMLibrary.OpenMM_CustomIntegrator_getKineticEnergyExpression((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumComputations() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getNumComputations((PointerByReference)this.pointer);
    }

    public int getNumGlobalVariables() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getNumGlobalVariables((PointerByReference)this.pointer);
    }

    public int getNumPerDofVariables() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getNumPerDofVariables((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public void getPerDofVariable(int index, PointerByReference variable) {
        OpenMMLibrary.OpenMM_CustomIntegrator_getPerDofVariable((PointerByReference)this.pointer, (int)index, (PointerByReference)variable);
    }

    public void getPerDofVariableByName(String name, PointerByReference variable) {
        OpenMMLibrary.OpenMM_CustomIntegrator_getPerDofVariableByName((PointerByReference)this.pointer, (String)name, (PointerByReference)variable);
    }

    public String getPerDofVariableName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomIntegrator_getPerDofVariableName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getRandomNumberSeed() {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomIntegrator_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomIntegrator_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setGlobalVariable(int index, double value) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setGlobalVariable((PointerByReference)this.pointer, (int)index, (double)value);
    }

    public void setGlobalVariableByName(String name, double value) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setGlobalVariableByName((PointerByReference)this.pointer, (String)name, (double)value);
    }

    public void setKineticEnergyExpression(String expression) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setKineticEnergyExpression((PointerByReference)this.pointer, (String)expression);
    }

    public void setPerDofVariable(int index, PointerByReference variable) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setPerDofVariable((PointerByReference)this.pointer, (int)index, (PointerByReference)variable);
    }

    public void setPerDofVariableByName(String name, PointerByReference variable) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setPerDofVariableByName((PointerByReference)this.pointer, (String)name, (PointerByReference)variable);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMLibrary.OpenMM_CustomIntegrator_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    @Override
    public void step(int steps) {
        OpenMMLibrary.OpenMM_CustomIntegrator_step((PointerByReference)this.pointer, (int)steps);
    }
}

