/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.IntBuffer;

public class CMAPTorsionForce
extends Force {
    public CMAPTorsionForce() {
        super(OpenMMLibrary.OpenMM_CMAPTorsionForce_create());
    }

    public int addMap(int size, PointerByReference energy) {
        return OpenMMLibrary.OpenMM_CMAPTorsionForce_addMap((PointerByReference)this.pointer, (int)size, (PointerByReference)energy);
    }

    public int addTorsion(int map, int a1, int a2, int a3, int a4, int b1, int b2, int b3, int b4) {
        return OpenMMLibrary.OpenMM_CMAPTorsionForce_addTorsion((PointerByReference)this.pointer, (int)map, (int)a1, (int)a2, (int)a3, (int)a4, (int)b1, (int)b2, (int)b3, (int)b4);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CMAPTorsionForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getMapParameters(int index, IntByReference size, PointerByReference energy) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_getMapParameters((PointerByReference)this.pointer, (int)index, (IntByReference)size, (PointerByReference)energy);
    }

    public void getMapParameters(int index, IntBuffer size, PointerByReference energy) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_getMapParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)size, (PointerByReference)energy);
    }

    public int getNumMaps() {
        return OpenMMLibrary.OpenMM_CMAPTorsionForce_getNumMaps((PointerByReference)this.pointer);
    }

    public int getNumTorsions() {
        return OpenMMLibrary.OpenMM_CMAPTorsionForce_getNumTorsions((PointerByReference)this.pointer);
    }

    public void getTorsionParameters(int index, IntByReference map, IntByReference a1, IntByReference a2, IntByReference a3, IntByReference a4, IntByReference b1, IntByReference b2, IntByReference b3, IntByReference b4) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_getTorsionParameters((PointerByReference)this.pointer, (int)index, (IntByReference)map, (IntByReference)a1, (IntByReference)a2, (IntByReference)a3, (IntByReference)a4, (IntByReference)b1, (IntByReference)b2, (IntByReference)b3, (IntByReference)b4);
    }

    public void getTorsionParameters(int index, IntBuffer map, IntBuffer a1, IntBuffer a2, IntBuffer a3, IntBuffer a4, IntBuffer b1, IntBuffer b2, IntBuffer b3, IntBuffer b4) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_getTorsionParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)map, (IntBuffer)a1, (IntBuffer)a2, (IntBuffer)a3, (IntBuffer)a4, (IntBuffer)b1, (IntBuffer)b2, (IntBuffer)b3, (IntBuffer)b4);
    }

    public void setMapParameters(int index, int size, PointerByReference energy) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_setMapParameters((PointerByReference)this.pointer, (int)index, (int)size, (PointerByReference)energy);
    }

    public void setTorsionParameters(int index, int map, int a1, int a2, int a3, int a4, int b1, int b2, int b3, int b4) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_setTorsionParameters((PointerByReference)this.pointer, (int)index, (int)map, (int)a1, (int)a2, (int)a3, (int)a4, (int)b1, (int)b2, (int)b3, (int)b4);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_CMAPTorsionForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CMAPTorsionForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CMAPTorsionForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

