/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import org.openscience.cdk.tools.ILoggingTool;

final class StdErrLogger
implements ILoggingTool {
    private int level;
    private final String classname;
    private int stackLength;

    public StdErrLogger(Class<?> classInst) {
        this.classname = classInst.getName();
        String val = System.getProperty("cdk.logging.level", "warn");
        switch (val.toLowerCase(Locale.ROOT)) {
            case "trace": {
                this.level = 0;
                break;
            }
            case "debug": {
                this.level = 1;
                break;
            }
            case "info": {
                this.level = 2;
                break;
            }
            case "warn": {
                this.level = 3;
                break;
            }
            case "error": {
                this.level = 4;
                break;
            }
            case "fatal": {
                this.level = 5;
                break;
            }
            default: {
                this.level = 3;
            }
        }
        if (System.getProperty("cdk.debugging", "false").equals("true") || System.getProperty("cdk.debug.stdout", "false").equals("true")) {
            this.level = 1;
        }
    }

    @Override
    public void dumpSystemProperties() {
        this.debug("os.name        : " + System.getProperty("os.name"));
        this.debug("os.version     : " + System.getProperty("os.version"));
        this.debug("os.arch        : " + System.getProperty("os.arch"));
        this.debug("java.version   : " + System.getProperty("java.version"));
        this.debug("java.vendor    : " + System.getProperty("java.vendor"));
    }

    @Override
    public void setStackLength(int length) {
        this.stackLength = length;
    }

    @Override
    public void dumpClasspath() {
        this.debug("java.class.path: " + System.getProperty("java.class.path"));
    }

    @Override
    public void debug(Object object) {
        if (this.level <= 1) {
            if (object instanceof Throwable) {
                this.debugThrowable((Throwable)object);
            } else {
                this.debugString("" + object);
            }
        }
    }

    private void debugString(String string) {
        this.printToStderr("DEBUG", string);
    }

    @Override
    public void debug(Object object, Object ... objects) {
        if (this.level <= 1) {
            StringBuilder result = new StringBuilder();
            result.append(object);
            for (Object obj : objects) {
                result.append(obj);
            }
            this.debugString(result.toString());
        }
    }

    private void debugThrowable(Throwable problem) {
        if (problem != null) {
            if (problem instanceof Error) {
                this.debug("Error: ", problem.getMessage());
            } else {
                this.debug("Exception: ", problem.getMessage());
            }
            StringWriter stackTraceWriter = new StringWriter();
            problem.printStackTrace(new PrintWriter(stackTraceWriter));
            String trace = stackTraceWriter.toString();
            try {
                BufferedReader reader = new BufferedReader(new StringReader(trace));
                if (reader.ready()) {
                    String traceLine = reader.readLine();
                    for (int counter = 0; reader.ready() && traceLine != null && counter < this.stackLength; ++counter) {
                        this.debug(traceLine);
                        traceLine = reader.readLine();
                    }
                }
            }
            catch (Exception ioException) {
                this.error("Serious error in LoggingTool while printing exception stack trace: ", ioException.getMessage());
            }
            Throwable cause = problem.getCause();
            if (cause != null) {
                this.debug("Caused by: ");
                this.debugThrowable(cause);
            }
        }
    }

    @Override
    public void error(Object object) {
        if (this.level <= 4) {
            this.errorString("" + object);
        }
    }

    @Override
    public void error(Object object, Object ... objects) {
        if (this.level <= 4) {
            StringBuilder result = new StringBuilder();
            result.append(object);
            for (Object obj : objects) {
                result.append(obj);
            }
            this.errorString(result.toString());
        }
    }

    private void errorString(String string) {
        this.printToStderr("ERROR", string);
    }

    @Override
    public void fatal(Object object) {
        if (this.level <= 5) {
            this.printToStderr("FATAL", object.toString());
        }
    }

    @Override
    public void info(Object object) {
        if (this.level <= 2) {
            this.infoString("" + object);
        }
    }

    @Override
    public void info(Object object, Object ... objects) {
        if (this.level <= 2) {
            StringBuilder result = new StringBuilder();
            result.append(object);
            for (Object obj : objects) {
                result.append(obj);
            }
            this.infoString(result.toString());
        }
    }

    private void infoString(String string) {
        this.printToStderr("INFO", string);
    }

    @Override
    public void warn(Object object) {
        if (this.level <= 3) {
            this.warnString("" + object);
        }
    }

    private void warnString(String string) {
        this.printToStderr("WARN", string);
    }

    @Override
    public void warn(Object object, Object ... objects) {
        if (this.level <= 3) {
            StringBuilder result = new StringBuilder();
            result.append(object);
            for (Object obj : objects) {
                result.append(obj);
            }
            this.warnString(result.toString());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    private void printToStderr(String level, String message) {
        for (String line : message.split("\n")) {
            System.err.println(this.classname + ' ' + level + ": " + line);
        }
    }

    public static ILoggingTool create(Class<?> sourceClass) {
        return new StdErrLogger(sourceClass);
    }

    @Deprecated
    void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.setLevel(1);
        } else {
            this.setLevel(5);
        }
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

