/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DefaultChemObjectReaderErrorHandler
implements IChemObjectReaderErrorHandler {
    private final ILoggingTool logger;

    public DefaultChemObjectReaderErrorHandler() {
        this(DefaultChemObjectReaderErrorHandler.class);
    }

    public DefaultChemObjectReaderErrorHandler(Class<?> clazz) {
        this(LoggingToolFactory.createLoggingTool(clazz));
    }

    public DefaultChemObjectReaderErrorHandler(ILoggingTool logger) {
        this.logger = logger;
    }

    @Override
    public void handleError(String message) {
        this.logger.error(message);
    }

    @Override
    public void handleError(String message, Exception exception) {
        this.logger.error(message, ", ", exception);
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd) {
        this.logger.error(message, ", row ", row, " column ", colStart, "-", colEnd);
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd, Exception exception) {
        this.logger.error(message + ", row ", row, " column ", colStart, "-", colEnd, ", ", exception);
    }

    @Override
    public void handleFatalError(String message) {
        this.logger.fatal(message);
    }

    @Override
    public void handleFatalError(String message, Exception exception) {
        this.logger.fatal(message + ", " + exception);
    }

    @Override
    public void handleFatalError(String message, int row, int colStart, int colEnd) {
        this.logger.fatal(message + ", row " + row + " column " + colStart + "-" + colEnd);
    }

    @Override
    public void handleFatalError(String message, int row, int colStart, int colEnd, Exception exception) {
        this.logger.fatal(message + ", row " + row + " column " + colStart + "-" + colEnd + ", " + exception);
    }
}

