/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;

public interface IReaction
extends IChemObject,
Iterable<IAtomContainer> {
    public int getReactantCount();

    public int getProductCount();

    public int getAgentCount();

    public IAtomContainerSet getReactants();

    public void setReactants(IAtomContainerSet var1);

    public IAtomContainerSet getProducts();

    public void setProducts(IAtomContainerSet var1);

    public IAtomContainerSet getAgents();

    @Override
    default public Iterator<IAtomContainer> iterator() {
        return new Iterator<IAtomContainer>(){
            private final Iterator[] sets;
            int pos;
            IAtomContainer next;
            {
                this.sets = new Iterator[]{IReaction.this.getReactants().iterator(), IReaction.this.getAgents().iterator(), IReaction.this.getProducts().iterator()};
                this.pos = 0;
            }

            private IAtomContainer loadNext() {
                if (this.next != null) {
                    return this.next;
                }
                while (this.pos < this.sets.length) {
                    if (this.sets[this.pos].hasNext()) {
                        this.next = (IAtomContainer)this.sets[this.pos].next();
                        break;
                    }
                    ++this.pos;
                }
                return this.next;
            }

            @Override
            public boolean hasNext() {
                return this.loadNext() != null;
            }

            @Override
            public IAtomContainer next() {
                IAtomContainer res = this.loadNext();
                this.next = null;
                return res;
            }
        };
    }

    public Iterable<IMapping> mappings();

    public void addReactant(IAtomContainer var1);

    public void addAgent(IAtomContainer var1);

    public void addReactant(IAtomContainer var1, Double var2);

    public void addProduct(IAtomContainer var1);

    public void addProduct(IAtomContainer var1, Double var2);

    public Double getReactantCoefficient(IAtomContainer var1);

    public Double getProductCoefficient(IAtomContainer var1);

    public boolean setReactantCoefficient(IAtomContainer var1, Double var2);

    public boolean setProductCoefficient(IAtomContainer var1, Double var2);

    public Double[] getReactantCoefficients();

    public Double[] getProductCoefficients();

    public boolean setReactantCoefficients(Double[] var1);

    public boolean setProductCoefficients(Double[] var1);

    public void setDirection(Direction var1);

    public Direction getDirection();

    public void addMapping(IMapping var1);

    public void removeMapping(int var1);

    public IMapping getMapping(int var1);

    public int getMappingCount();

    public static enum Direction {
        FORWARD,
        BACKWARD,
        BIDIRECTIONAL,
        NO_GO,
        RETRO_SYNTHETIC,
        RESONANCE,
        UNDIRECTED;

    }
}

