/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.Iterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;

public interface IAtom
extends IAtomType {
    public void setCharge(Double var1);

    public Double getCharge();

    public void setImplicitHydrogenCount(Integer var1);

    public Integer getImplicitHydrogenCount();

    default public Integer getTotalHydrogenCount() {
        Integer count = this.getImplicitHydrogenCount();
        if (count == null) {
            return null;
        }
        for (IAtom nbor : this.neighbors()) {
            Integer elem = nbor.getAtomicNumber();
            if (elem == null || elem != 1) continue;
            Integer n = count;
            count = count + 1;
        }
        return count;
    }

    public void setPoint2d(Point2d var1);

    public void setPoint3d(Point3d var1);

    public void setFractionalPoint3d(Point3d var1);

    @Deprecated
    public void setStereoParity(Integer var1);

    public Point2d getPoint2d();

    public Point3d getPoint3d();

    public Point3d getFractionalPoint3d();

    @Deprecated
    public Integer getStereoParity();

    public IAtomContainer getContainer();

    public int getIndex();

    public Iterable<IBond> bonds();

    default public Iterable<IAtom> neighbors() {
        final IAtom atom = this;
        return () -> new Iterator<IAtom>(){
            private final Iterator<IBond> bondIter;
            {
                this.bondIter = atom.bonds().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.bondIter.hasNext();
            }

            @Override
            public IAtom next() {
                return this.bondIter.next().getOther(atom);
            }
        };
    }

    public int getBondCount();

    public IBond getBond(IAtom var1);

    default public boolean isAromatic() {
        return this.is(32);
    }

    default public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    default public boolean isInRing() {
        return this.is(2);
    }

    default public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    public int getMapIdx();

    public void setMapIdx(int var1);

    @Override
    public IAtom clone() throws CloneNotSupportedException;
}

