/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

enum ChemObjectBuilderCache {
    INSTANCE;

    private final IChemObjectBuilder silentBuilder = ChemObjectBuilderCache.load("org.openscience.cdk.silent.SilentChemObjectBuilder");
    private final IChemObjectBuilder defaultBuilder = ChemObjectBuilderCache.load("org.openscience.cdk.DefaultChemObjectBuilder");

    private static IChemObjectBuilder load(String path) {
        try {
            Class<?> cls = Class.forName(path);
            Method method = cls.getDeclaredMethod("getInstance", new Class[0]);
            return (IChemObjectBuilder)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public IChemObjectBuilder get() {
        if (this.silentBuilder != null) {
            return this.silentBuilder;
        }
        return this.defaultBuilder;
    }
}

