/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.TinkerUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface PotentialsFunctions {
    public static final Logger logger = Logger.getLogger(PotentialsFunctions.class.getName());

    public void close(MolecularAssembly var1);

    public void closeAll(MolecularAssembly[] var1);

    public ForceFieldEnergy energy(MolecularAssembly var1);

    public ForceFieldEnergy[] energy(MolecularAssembly[] var1);

    default public MolecularAssembly getActiveAssembly() {
        SystemFilter systemFilter = this.getFilter();
        if (systemFilter != null) {
            return systemFilter.getActiveMolecularSystem();
        }
        return null;
    }

    default public List<String> getArguments() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public SystemFilter getFilter();

    public boolean isLocal();

    default public MolecularAssembly open(String filename) {
        MolecularAssembly[] assemblies = this.openAll(filename);
        if (assemblies.length > 1) {
            logger.log(Level.WARNING, " Found multiple assemblies in file {0}, opening first.", filename);
        }
        return assemblies[0];
    }

    default public MolecularAssembly[] open(String[] files, int nThreads) {
        return this.openAll(files);
    }

    public MolecularAssembly[] openAll(String var1);

    public MolecularAssembly[] openAll(String[] var1);

    default public MolecularAssembly[] openAll(String file, int nThreads) {
        return this.openAll(file);
    }

    public double returnEnergy(MolecularAssembly var1);

    public void save(MolecularAssembly var1, File var2);

    public void saveAsXYZinP1(MolecularAssembly var1, File var2);

    public void saveAsXYZasReplicates(MolecularAssembly var1, File var2, int[] var3);

    public void saveAsPDB(MolecularAssembly var1, File var2);

    public void saveAsPDB(MolecularAssembly[] var1, File var2);

    public void saveAsPDB(MolecularAssembly var1, File var2, boolean var3, boolean var4);

    public void saveAsXYZ(MolecularAssembly var1, File var2);

    public void saveAsPDBinP1(MolecularAssembly var1, File var2);

    public double time();

    default public String versionFile(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must not be null!");
        }
        return this.versionFile(new File(filename)).getName();
    }

    default public File versionFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        return TinkerUtils.version((File)file);
    }
}

