/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.UreyBradley;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class UreyBradleyPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(UreyBradleyPotentialEnergy.class.getName());
    private final List<UreyBradley> ureyBradleys = new ArrayList<UreyBradley>();

    public UreyBradleyPotentialEnergy(String name) {
        super(name);
    }

    public UreyBradleyPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public UreyBradleyPotentialEnergy(String name, int forceGroup, List<UreyBradley> ureyBradleys) {
        super(name, forceGroup);
        if (ureyBradleys != null) {
            Collections.sort(ureyBradleys);
            this.ureyBradleys.addAll(ureyBradleys);
            logger.info(String.format("  Urey-Bradleys:                     %10d", this.getNumberOfUreyBradleys()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfUreyBradleys();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getUreyBradleyArray();
    }

    public UreyBradleyPotentialEnergy(String name, Collection<UreyBradley> ureyBradleys) {
        super(name);
        if (ureyBradleys != null) {
            this.ureyBradleys.addAll(ureyBradleys);
        }
    }

    public boolean addUreyBradley(UreyBradley ureyBradley) {
        if (ureyBradley == null) {
            return false;
        }
        return this.ureyBradleys.add(ureyBradley);
    }

    public boolean addUreyBradleys(UreyBradley[] ureyBradleys) {
        if (ureyBradleys == null) {
            return false;
        }
        Collections.addAll(this.ureyBradleys, ureyBradleys);
        return true;
    }

    public boolean addUreyBradleys(List<UreyBradley> ureyBradleys) {
        if (ureyBradleys == null) {
            return false;
        }
        this.ureyBradleys.addAll(ureyBradleys);
        return true;
    }

    public boolean removeUreyBradley(UreyBradley ureyBradley) {
        if (ureyBradley == null) {
            return false;
        }
        return this.ureyBradleys.remove(ureyBradley);
    }

    public UreyBradley getUreyBradley(int index) {
        return this.ureyBradleys.get(index);
    }

    public List<UreyBradley> getUreyBradleys() {
        return Collections.unmodifiableList(this.ureyBradleys);
    }

    public UreyBradley[] getUreyBradleyArray() {
        return this.ureyBradleys.toArray(new UreyBradley[0]);
    }

    public int getNumberOfUreyBradleys() {
        return this.ureyBradleys.size();
    }

    @Override
    public void log() {
        if (this.getNumberOfUreyBradleys() <= 0) {
            return;
        }
        logger.info("\n Urey-Bradley Interactions:");
        for (UreyBradley ureyBradley : this.getUreyBradleys()) {
            logger.info("Urey-Bradley \t" + ureyBradley.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfUreyBradleys() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "UREY-BRADLEY               : ", this.getEnergy(), this.getNumberOfUreyBradleys());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Urey-Bradley      ", this.getEnergy(), this.getNumberOfUreyBradleys(), this.getTime());
    }
}

