/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.Torsion;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class TorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(TorsionPotentialEnergy.class.getName());
    private final List<Torsion> torsions = new ArrayList<Torsion>();

    public TorsionPotentialEnergy(String name) {
        super(name);
    }

    public TorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public TorsionPotentialEnergy(String name, int forceGroup, List<Torsion> torsions) {
        super(name, forceGroup);
        if (torsions != null) {
            Collections.sort(torsions);
            this.torsions.addAll(torsions);
            logger.info(String.format("  Torsions:                          %10d", this.getNumberOfTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getTorsionArray();
    }

    public TorsionPotentialEnergy(String name, Collection<Torsion> torsions) {
        super(name);
        if (torsions != null) {
            this.torsions.addAll(torsions);
        }
    }

    public boolean addTorsion(Torsion torsion) {
        if (torsion == null) {
            return false;
        }
        return this.torsions.add(torsion);
    }

    public boolean addTorsions(Torsion[] torsions) {
        if (torsions == null) {
            return false;
        }
        Collections.addAll(this.torsions, torsions);
        return true;
    }

    public boolean addTorsions(List<Torsion> torsions) {
        if (torsions == null) {
            return false;
        }
        this.torsions.addAll(torsions);
        return true;
    }

    public boolean removeTorsion(Torsion torsion) {
        if (torsion == null) {
            return false;
        }
        return this.torsions.remove(torsion);
    }

    public Torsion getTorsion(int index) {
        return this.torsions.get(index);
    }

    public List<Torsion> getTorsions() {
        return Collections.unmodifiableList(this.torsions);
    }

    public Torsion[] getTorsionArray() {
        return this.torsions.toArray(new Torsion[0]);
    }

    public int getNumberOfTorsions() {
        return this.torsions.size();
    }

    public void setLambda(double lambda) {
        for (Torsion torsion : this.torsions) {
            torsion.setLambda(lambda);
        }
    }

    public double getdEdL() {
        double dEdL = 0.0;
        for (Torsion torsion : this.getTorsions()) {
            dEdL += torsion.getdEdL();
        }
        return dEdL;
    }

    public double getd2EdL2() {
        double d2EdLambda2 = 0.0;
        for (Torsion torsion : this.getTorsions()) {
            d2EdLambda2 += torsion.getd2EdL2();
        }
        return d2EdLambda2;
    }

    @Override
    public void log() {
        if (this.getNumberOfTorsions() <= 0) {
            return;
        }
        logger.info("\n Torsion Angle Interactions:");
        for (Torsion torsion : this.getTorsions()) {
            logger.info(" Torsion \t" + torsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "TORSIONAL ANGLE            : ", this.getEnergy(), this.getNumberOfTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Torsional Angle   ", this.getEnergy(), this.getNumberOfTorsions(), this.getTime());
    }
}

